/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.generators;

import java.util.ArrayList;
import java.util.List;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ReportResult;
import net.masterthought.cucumber.generators.AbstractPage;
import net.masterthought.cucumber.json.Element;
import net.masterthought.cucumber.json.Feature;

public class FailuresOverviewPage
extends AbstractPage {
    public static final String WEB_PAGE = "overview-failures.html";

    public FailuresOverviewPage(ReportResult reportResult, Configuration configuration) {
        super(reportResult, "overviewFailures.vm", configuration);
    }

    @Override
    public String getWebPage() {
        return WEB_PAGE;
    }

    @Override
    public void prepareReport() {
        this.context.put("failures", this.collectFailures());
    }

    private List<Element> collectFailures() {
        ArrayList<Element> failures = new ArrayList<Element>();
        for (Feature feature : this.reportResult.getAllFeatures()) {
            if (feature.getStatus().isPassed()) continue;
            for (Element element : feature.getElements()) {
                if (element.getStatus().isPassed()) continue;
                failures.add(element);
            }
        }
        return failures;
    }
}

