/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.jenkins;

import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import net.masterthought.cucumber.sorting.SortingMethod;
import net.masterthought.jenkins.Messages;
import org.kohsuke.stapler.QueryParameter;

public class CucumberReportDescriptor
extends BuildStepDescriptor<Publisher> {
    public String getDisplayName() {
        return Messages.Plugin_DisplayName();
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return true;
    }

    public ListBoxModel doFillBuildStatusItems() {
        return new ListBoxModel(new ListBoxModel.Option[]{new ListBoxModel.Option(Messages.BuildStatus_unchanged(), null), new ListBoxModel.Option(Messages.BuildStatus_FAILURE(), Result.FAILURE.toString()), new ListBoxModel.Option(Messages.BuildStatus_UNSTABLE(), Result.UNSTABLE.toString())});
    }

    public FormValidation doCheckTrendsLimit(@QueryParameter String value) {
        return CucumberReportDescriptor.isValidNumber(value);
    }

    public FormValidation doCheckFailedStepsNumber(@QueryParameter String value) {
        return CucumberReportDescriptor.isValidNumber(value);
    }

    public FormValidation doCheckSkippedStepsNumber(@QueryParameter String value) {
        return CucumberReportDescriptor.isValidNumber(value);
    }

    public FormValidation doCheckPendingStepsNumber(@QueryParameter String value) {
        return CucumberReportDescriptor.isValidNumber(value);
    }

    public FormValidation doCheckUndefinedStepsNumber(@QueryParameter String value) {
        return CucumberReportDescriptor.isValidNumber(value);
    }

    public FormValidation doCheckFailedScenariosNumber(@QueryParameter String value) {
        return CucumberReportDescriptor.isValidNumber(value);
    }

    public FormValidation doCheckFailedFeaturesNumber(@QueryParameter String value) {
        return CucumberReportDescriptor.isValidNumber(value);
    }

    private static FormValidation isValidNumber(String value) {
        try {
            int intValue = Integer.parseInt(value);
            if (intValue >= 0) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.Configuration_notValidNumberRange());
        }
        catch (NumberFormatException e) {
            return FormValidation.error((String)Messages.Configuration_notValidNumber());
        }
    }

    public ListBoxModel doFillSortingMethodItems() {
        return new ListBoxModel(new ListBoxModel.Option[]{new ListBoxModel.Option(Messages.SortingMethod_ALPHABETICAL(), SortingMethod.ALPHABETICAL.name()), new ListBoxModel.Option(Messages.SortingMethod_NATURAL(), SortingMethod.NATURAL.name())});
    }
}

