/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.jenkins;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ReportBuilder;
import net.masterthought.cucumber.Reportable;
import net.masterthought.cucumber.sorting.SortingMethod;
import net.masterthought.jenkins.CucumberReportDescriptor;
import net.masterthought.jenkins.Messages;
import net.masterthought.jenkins.SafeArchiveServingRunAction;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CucumberReportPublisher
extends Publisher
implements SimpleBuildStep {
    private static final String DEFAULT_FILE_INCLUDE_PATTERN = "**/*.json";
    private static final String DEFAULT_FILE_INCLUDE_PATTERN_CLASSIFICATIONS = "**/*.properties";
    private static final String TRENDS_DIR = "cucumber-reports";
    private static final String TRENDS_FILE = "cucumber-trends.json";
    private final String fileIncludePattern;
    private String fileExcludePattern = "";
    private String jsonReportDirectory = "";
    private int failedStepsNumber;
    private int skippedStepsNumber;
    private int pendingStepsNumber;
    private int undefinedStepsNumber;
    private int failedScenariosNumber;
    private int failedFeaturesNumber;
    private String buildStatus;
    private int trendsLimit;
    private boolean parallelTesting;
    private String sortingMethod = SortingMethod.NATURAL.name();
    private List<Classification> classifications = Collections.emptyList();
    private String classificationsFilePattern = "";

    @DataBoundConstructor
    public CucumberReportPublisher(String fileIncludePattern) {
        this.fileIncludePattern = fileIncludePattern;
    }

    @Deprecated
    public CucumberReportPublisher(String jsonReportDirectory, String fileIncludePattern, String fileExcludePattern, int failedStepsNumber, int skippedStepsNumber, int pendingStepsNumber, int undefinedStepsNumber, int failedScenariosNumber, int failedFeaturesNumber, String buildStatus, String sortingMethod) {
        this.jsonReportDirectory = jsonReportDirectory;
        this.fileIncludePattern = fileIncludePattern;
        this.fileExcludePattern = fileExcludePattern;
        this.failedStepsNumber = failedStepsNumber;
        this.skippedStepsNumber = skippedStepsNumber;
        this.pendingStepsNumber = pendingStepsNumber;
        this.undefinedStepsNumber = undefinedStepsNumber;
        this.failedScenariosNumber = failedScenariosNumber;
        this.failedFeaturesNumber = failedFeaturesNumber;
        this.buildStatus = buildStatus;
        this.sortingMethod = sortingMethod;
    }

    private static void log(TaskListener listener, String message) {
        listener.getLogger().println("[CucumberReport] " + message);
    }

    public String getFileIncludePattern() {
        return this.fileIncludePattern;
    }

    public List<Classification> getClassifications() {
        return this.classifications;
    }

    @DataBoundSetter
    public void setClassifications(List<Classification> classifications) {
        if (CollectionUtils.isNotEmpty(classifications)) {
            this.classifications = classifications;
        }
    }

    public int getTrendsLimit() {
        return this.trendsLimit;
    }

    @DataBoundSetter
    public void setTrendsLimit(int trendsLimit) {
        this.trendsLimit = trendsLimit;
    }

    public String getFileExcludePattern() {
        return this.fileExcludePattern;
    }

    @DataBoundSetter
    public void setFileExcludePattern(String fileExcludePattern) {
        this.fileExcludePattern = fileExcludePattern;
    }

    public String getJsonReportDirectory() {
        return this.jsonReportDirectory;
    }

    @DataBoundSetter
    public void setJsonReportDirectory(String jsonReportDirectory) {
        this.jsonReportDirectory = jsonReportDirectory;
    }

    public int getFailedStepsNumber() {
        return this.failedStepsNumber;
    }

    @DataBoundSetter
    public void setFailedStepsNumber(int failedStepsNumber) {
        this.failedStepsNumber = failedStepsNumber;
    }

    public int getSkippedStepsNumber() {
        return this.skippedStepsNumber;
    }

    @DataBoundSetter
    public void setSkippedStepsNumber(int skippedStepsNumber) {
        this.skippedStepsNumber = skippedStepsNumber;
    }

    public int getPendingStepsNumber() {
        return this.pendingStepsNumber;
    }

    @DataBoundSetter
    public void setPendingStepsNumber(int pendingStepsNumber) {
        this.pendingStepsNumber = pendingStepsNumber;
    }

    public int getUndefinedStepsNumber() {
        return this.undefinedStepsNumber;
    }

    @DataBoundSetter
    public void setUndefinedStepsNumber(int undefinedStepsNumber) {
        this.undefinedStepsNumber = undefinedStepsNumber;
    }

    public int getFailedScenariosNumber() {
        return this.failedScenariosNumber;
    }

    @DataBoundSetter
    public void setFailedScenariosNumber(int failedScenariosNumber) {
        this.failedScenariosNumber = failedScenariosNumber;
    }

    public int getFailedFeaturesNumber() {
        return this.failedFeaturesNumber;
    }

    @DataBoundSetter
    public void setFailedFeaturesNumber(int failedFeaturesNumber) {
        this.failedFeaturesNumber = failedFeaturesNumber;
    }

    public String getBuildStatus() {
        return this.buildStatus;
    }

    @DataBoundSetter
    public void setBuildStatus(String buildStatus) {
        this.buildStatus = buildStatus;
    }

    public boolean isParallelTesting() {
        return this.parallelTesting;
    }

    @DataBoundSetter
    public void setParallelTesting(boolean parallelTesting) {
        this.parallelTesting = parallelTesting;
    }

    @DataBoundSetter
    public void setSortingMethod(String sortingMethod) {
        this.sortingMethod = sortingMethod;
    }

    public String getSortingMethod() {
        return this.sortingMethod;
    }

    @DataBoundSetter
    public void setClassificationsFilePattern(String classificationsFilePattern) {
        this.classificationsFilePattern = classificationsFilePattern;
    }

    public String getClassificationsFilePattern() {
        return this.classificationsFilePattern;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        this.generateReport(run, workspace, listener);
        SafeArchiveServingRunAction caa = new SafeArchiveServingRunAction(run, new File(run.getRootDir(), "cucumber-html-reports"), "cucumber-html-reports", "overview-features.html", "/plugin/cucumber-reports/icon.png", Messages.SidePanel_DisplayName(), new String[0]);
        run.replaceAction((Action)caa);
    }

    private void generateReport(Run<?, ?> build, FilePath workspace, TaskListener listener) throws InterruptedException, IOException {
        ReportBuilder reportBuilder;
        Reportable result;
        List<String> classificationFiles;
        CucumberReportPublisher.log(listener, "Preparing Cucumber Reports");
        File trendsDir = new File(build.getParent().getRootDir(), TRENDS_DIR);
        if (!trendsDir.exists() && !trendsDir.mkdir()) {
            throw new IllegalStateException("Could not create directory for trends: " + trendsDir);
        }
        String parsedJsonReportDirectory = this.evaluateMacro(build, workspace, listener, this.jsonReportDirectory);
        CucumberReportPublisher.log(listener, String.format("JSON report directory is \"%s\"", parsedJsonReportDirectory));
        FilePath inputDirectory = new FilePath(workspace, parsedJsonReportDirectory);
        File directoryForReport = build.getRootDir();
        File directoryJsonCache = new File(directoryForReport, "cucumber-html-reports" + File.separatorChar + ".cache");
        if (!directoryJsonCache.exists() && !directoryJsonCache.mkdirs()) {
            throw new IllegalStateException("Could not create directory for cache: " + directoryJsonCache);
        }
        int copiedFiles = inputDirectory.copyRecursiveTo(DEFAULT_FILE_INCLUDE_PATTERN, new FilePath(directoryJsonCache));
        CucumberReportPublisher.log(listener, String.format("Copied %d json files from workspace \"%s\" to reports directory \"%s\"", copiedFiles, inputDirectory.getRemote(), directoryJsonCache));
        int copiedFilesProperties = inputDirectory.copyRecursiveTo(DEFAULT_FILE_INCLUDE_PATTERN_CLASSIFICATIONS, new FilePath(directoryJsonCache));
        CucumberReportPublisher.log(listener, String.format("Copied %d properties files from workspace \"%s\" to reports directory \"%s\"", copiedFilesProperties, inputDirectory.getRemote(), directoryJsonCache));
        String[] jsonReportFiles = this.findJsonFiles(directoryJsonCache, this.fileIncludePattern, this.fileExcludePattern);
        List<String> jsonFilesToProcess = this.fullPathToJsonFiles(jsonReportFiles, directoryJsonCache);
        CucumberReportPublisher.log(listener, String.format("Processing %d json files:", jsonReportFiles.length));
        for (String jsonFile : jsonFilesToProcess) {
            CucumberReportPublisher.log(listener, jsonFile);
        }
        String buildNumber = Integer.toString(build.getNumber());
        String projectName = build.getParent().getDisplayName();
        Configuration configuration = new Configuration(directoryForReport, projectName);
        configuration.setParallelTesting(this.parallelTesting);
        configuration.setRunWithJenkins(true);
        configuration.setBuildNumber(buildNumber);
        configuration.setTrends(new File(trendsDir, TRENDS_FILE), this.trendsLimit);
        configuration.setSortingMethod(this.sortingMethod == null ? SortingMethod.NATURAL : SortingMethod.valueOf((String)this.sortingMethod));
        if (CollectionUtils.isNotEmpty(this.classifications)) {
            CucumberReportPublisher.log(listener, String.format("Adding %d classifications", this.classifications.size()));
            this.addClassificationsToBuildReport(build, workspace, listener, configuration, this.classifications);
        }
        if (CollectionUtils.isNotEmpty(classificationFiles = this.fetchPropertyFiles(directoryJsonCache, listener))) {
            configuration.addClassificationFiles(classificationFiles);
        }
        if (this.hasReportFailed(result = (reportBuilder = new ReportBuilder(jsonFilesToProcess, configuration)).generateReports(), listener)) {
            if (this.buildStatus != null) {
                CucumberReportPublisher.log(listener, "Build status is changed to " + this.buildStatus);
                build.setResult(Result.fromString((String)this.buildStatus));
            } else {
                CucumberReportPublisher.log(listener, "Build status is left unchanged");
            }
        }
    }

    private String[] findJsonFiles(File targetDirectory, String fileIncludePattern, String fileExcludePattern) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(targetDirectory);
        if (StringUtils.isEmpty((CharSequence)fileIncludePattern)) {
            scanner.setIncludes(new String[]{DEFAULT_FILE_INCLUDE_PATTERN});
        } else {
            scanner.setIncludes(new String[]{fileIncludePattern});
        }
        if (StringUtils.isNotEmpty((CharSequence)fileExcludePattern)) {
            scanner.setExcludes(new String[]{fileExcludePattern});
        }
        scanner.setBasedir(targetDirectory);
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    private List<String> fullPathToJsonFiles(String[] jsonFiles, File targetBuildDirectory) {
        ArrayList<String> fullPathList = new ArrayList<String>();
        for (String file : jsonFiles) {
            fullPathList.add(new File(targetBuildDirectory, file).getAbsolutePath());
        }
        return fullPathList;
    }

    private boolean hasReportFailed(Reportable result, TaskListener listener) {
        if (result == null) {
            CucumberReportPublisher.log(listener, "Missing report result - report was not successfully completed");
            return true;
        }
        if (result.getFailedSteps() > this.failedStepsNumber) {
            CucumberReportPublisher.log(listener, String.format("Found %d failed steps, while expected not more than %d", result.getFailedSteps(), this.failedStepsNumber));
            return true;
        }
        if (result.getSkippedSteps() > this.skippedStepsNumber) {
            CucumberReportPublisher.log(listener, String.format("Found %d skipped steps, while expected not more than %d", result.getSkippedSteps(), this.skippedStepsNumber));
            return true;
        }
        if (result.getPendingSteps() > this.pendingStepsNumber) {
            CucumberReportPublisher.log(listener, String.format("Found %d pending steps, while expected not more than %d", result.getPendingSteps(), this.pendingStepsNumber));
            return true;
        }
        if (result.getUndefinedSteps() > this.undefinedStepsNumber) {
            CucumberReportPublisher.log(listener, String.format("Found %d undefined steps, while expected not more than %d", result.getUndefinedSteps(), this.undefinedStepsNumber));
            return true;
        }
        if (result.getFailedScenarios() > this.failedScenariosNumber) {
            CucumberReportPublisher.log(listener, String.format("Found %d failed scenarios, while expected not more than %d", result.getFailedScenarios(), this.failedScenariosNumber));
            return true;
        }
        if (result.getFailedFeatures() > this.failedFeaturesNumber) {
            CucumberReportPublisher.log(listener, String.format("Found %d failed features, while expected not more than %d", result.getFailedFeatures(), this.failedFeaturesNumber));
            return true;
        }
        return false;
    }

    private String evaluateMacro(Run<?, ?> build, FilePath workspace, TaskListener listener, String value) throws InterruptedException, IOException {
        try {
            return TokenMacro.expandAll(build, (FilePath)workspace, (TaskListener)listener, (String)value);
        }
        catch (MacroEvaluationException e) {
            CucumberReportPublisher.log(listener, String.format("Could not evaluate macro '%s': %s", value, e.getMessage()));
            return value;
        }
    }

    private void addClassificationsToBuildReport(Run<?, ?> build, FilePath workspace, TaskListener listener, Configuration configuration, List<Classification> listToAdd) throws InterruptedException, IOException {
        for (Classification classification : listToAdd) {
            CucumberReportPublisher.log(listener, String.format("Adding classification - %s:%s", classification.key, classification.value));
            configuration.addClassifications(classification.key, this.evaluateMacro(build, workspace, listener, classification.value));
        }
    }

    private List<String> fetchPropertyFiles(File targetDirectory, TaskListener listener) {
        List<String> propertyFiles = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)this.classificationsFilePattern)) {
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setIncludes(new String[]{this.classificationsFilePattern});
            scanner.setBasedir(targetDirectory);
            scanner.setCaseSensitive(false);
            scanner.scan();
            propertyFiles = this.getFullMetaDataPath(scanner.getIncludedFiles(), targetDirectory.toString());
            for (String propertyFile : propertyFiles) {
                CucumberReportPublisher.log(listener, String.format("Found Properties File - %s ", propertyFile));
            }
        }
        return propertyFiles;
    }

    private List<String> getFullMetaDataPath(String[] files, String propertiesDirectory) {
        ArrayList<String> fullPathList = new ArrayList<String>();
        for (String file : files) {
            fullPathList.add(propertiesDirectory + File.separator + file);
        }
        return fullPathList;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Extension
    @Symbol(value={"cucumber"})
    public static class BuildStatusesDescriptorImpl
    extends CucumberReportDescriptor {
    }

    public static class Classification
    extends AbstractDescribableImpl<Classification>
    implements Serializable {
        public String key;
        public String value;

        @DataBoundConstructor
        public Classification(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<Classification> {
            public String getDisplayName() {
                return "";
            }
        }
    }
}

