/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.jenkins;

import hudson.model.Action;
import hudson.model.Run;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.RunAction2;
import jenkins.tasks.SimpleBuildStep;
import net.masterthought.jenkins.CucumberReportProjectAction;
import net.masterthought.jenkins.SafeArchiveServingAction;

public class SafeArchiveServingRunAction
extends SafeArchiveServingAction
implements RunAction2,
SimpleBuildStep.LastBuildAction {
    private Run<?, ?> run;
    private static final Logger LOGGER = Logger.getLogger(SafeArchiveServingRunAction.class.getName());

    public SafeArchiveServingRunAction(@Nonnull Run<?, ?> r, File rootDir, String urlName, String indexFile, String iconName, String title, String ... safeExtensions) {
        super(rootDir, urlName, indexFile, iconName, title, safeExtensions);
        this.run = r;
    }

    public void onAttached(Run<?, ?> r) {
        try {
            this.run = r;
            this.processDirectory();
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            LOGGER.log(Level.WARNING, "Exception scanning " + r.getRootDir(), ex);
        }
    }

    public void onLoad(Run<?, ?> r) {
        this.run = r;
    }

    public Collection<? extends Action> getProjectActions() {
        return Collections.singleton(new CucumberReportProjectAction(this.run.getParent()));
    }
}

