/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.cache.template;

import net.n2oapp.cache.template.CacheCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class CacheTemplate<K, E> {
    private static final Logger log = LoggerFactory.getLogger(CacheTemplate.class);
    private CacheManager cacheManager;

    public CacheTemplate() {
    }

    public CacheTemplate(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public E execute(String cacheRegion, K key, CacheCallback<E> callback) {
        Cache cache = this.getCacheManager().getCache(cacheRegion);
        if (cache != null) {
            Cache.ValueWrapper cacheValueWrapper = cache.get(key);
            if (cacheValueWrapper != null) {
                Object e = cacheValueWrapper.get();
                callback.doInCacheHit(e);
                return (E)e;
            }
        } else {
            log.warn("Cannot find cache named [" + cacheRegion + "] for CacheTemplate");
            return callback.doInCacheMiss();
        }
        return this.handleCache(key, callback, cache);
    }

    protected E handleCache(K key, CacheCallback<E> callback, Cache cache) {
        E value = callback.doInCacheMiss();
        cache.put(key, value);
        return value;
    }
}

