/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.criteria.dataset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;

public class ListMap<K, V>
extends HashMap<K, List<V>> {
    public void forEachValue(BiConsumer<K, V> action) {
        for (Object k : this.keySet()) {
            for (V v : this.getList(k)) {
                action.accept(k, v);
            }
        }
    }

    public void putToList(K key, V value) {
        this.getList(key).add(value);
    }

    public void putIfNotExists(K key, V value) {
        List<V> list = this.getList(key);
        if (!list.contains(value)) {
            list.add(value);
        }
    }

    private List<V> getList(K key) {
        ArrayList list = (ArrayList)this.get(key);
        if (list == null) {
            list = new ArrayList();
            this.put(key, list);
        }
        return list;
    }
}

