/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.criteria.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.n2oapp.criteria.dataset.NestedMap;

public class DataSet
extends NestedMap {
    public static final ValuePickUpStrategy ALWAYS_EXTEND_VALUE = (mainValue, extendValue) -> extendValue;
    public static final ValuePickUpStrategy EXTEND_IF_VALUE_NOT_NULL = (mainValue, extendValue) -> extendValue != null ? extendValue : mainValue;

    public DataSet() {
    }

    public DataSet(String key, Object value) {
        this.put(key, value);
    }

    public DataSet add(String key, Object value) {
        this.put(key, value);
        return this;
    }

    public DataSet(Map<? extends String, ?> m) {
        super(m);
    }

    public String getId() {
        return this.get("id") != null ? this.get("id").toString() : null;
    }

    public void merge(DataSet dataSet) {
        DataSet.merge(this, dataSet, ALWAYS_EXTEND_VALUE);
    }

    public void merge(DataSet dataSet, ValuePickUpStrategy strategy) {
        DataSet.merge(this, dataSet, strategy);
    }

    public Integer getInteger(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return Integer.parseInt((String)value);
    }

    public String getString(String key) {
        Object value = this.get(key);
        return (String)value;
    }

    public Long getLong(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return Long.parseLong((String)value);
    }

    public Boolean getBoolean(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.parseBoolean((String)value);
    }

    public DataSet getDataSet(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof DataSet) {
            return (DataSet)value;
        }
        return new DataSet((Map)value);
    }

    public List<?> getList(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            return (List)value;
        }
        if (value.getClass().isArray()) {
            return new ArrayList<Object>(Arrays.asList((Object[])value));
        }
        return new ArrayList((Collection)value);
    }

    private static void merge(NestedMap main, NestedMap extend, ValuePickUpStrategy strategy) {
        if (main == extend) {
            return;
        }
        if (extend == null) {
            return;
        }
        for (String fieldName : extend.keySet()) {
            Object mainValue = main.get(fieldName);
            Object extendValue = extend.get(fieldName);
            if (mainValue != null && mainValue instanceof NestedMap && extendValue instanceof NestedMap) {
                DataSet.merge((NestedMap)mainValue, (NestedMap)extendValue, strategy);
                continue;
            }
            if (mainValue != null && mainValue instanceof List && extendValue instanceof List) {
                DataSet.mergeArrays((List)mainValue, (List)extendValue);
                continue;
            }
            main.put(fieldName, strategy.pickUp(mainValue, extendValue));
        }
    }

    @Override
    protected NestedMap createNestedMap(Map map) {
        if (map == null) {
            return new DataSet();
        }
        return new DataSet(map);
    }

    public Set<String> flatKeySet() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Map.Entry entry : this.entrySet()) {
            if (entry.getValue() instanceof DataSet) {
                Set<String> childrenKeySet = ((DataSet)entry.getValue()).flatKeySet();
                for (String childKey : childrenKeySet) {
                    result.add((String)entry.getKey() + "." + childKey);
                }
                continue;
            }
            result.add((String)entry.getKey());
        }
        return result;
    }

    private static void mergeArrays(List mainArray, List updateArray) {
        mainArray.addAll(updateArray);
    }

    public static boolean isSpreadKey(String key) {
        return key.contains("*.");
    }

    public static interface ValuePickUpStrategy {
        public Object pickUp(Object var1, Object var2);
    }
}

