/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.criteria.dataset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.n2oapp.criteria.dataset.NestedMap;
import net.n2oapp.criteria.dataset.NestedUtils;

public class NestedList
extends ArrayList<Object> {
    public NestedList() {
    }

    public NestedList(Collection<?> c) {
        super(c.size());
        int i = 0;
        for (Object o : c) {
            this.put("[" + i + "]", o);
            ++i;
        }
    }

    public Object get(String key) {
        KeyInfo info = NestedList.getKeyInfo(key);
        if (this.size() <= info.getIndex()) {
            return null;
        }
        Object value = super.get(info.getIndex());
        if (value == null) {
            return null;
        }
        if (!info.isNesting()) {
            return value;
        }
        if (!info.isSpread()) {
            if (NestedUtils.applicableFor(value, info.getRight(), Map.class)) {
                return ((Map)value).get(info.getRight());
            }
            if (NestedUtils.applicableFor(value, info.getRight(), NestedList.class)) {
                return ((NestedList)value).get(info.getRight());
            }
            return null;
        }
        if (!(value instanceof List)) {
            return null;
        }
        List array = (List)value;
        ArrayList<Object> result = new ArrayList<Object>(array.size());
        for (Object o : array) {
            Object child = null;
            if (o instanceof Map) {
                child = ((Map)o).get(info.getRight());
            }
            result.add(child);
        }
        return Collections.unmodifiableList(result);
    }

    public Object put(String key, Object value) {
        KeyInfo info = NestedList.getKeyInfo(key);
        if (!info.isNesting()) {
            NestedUtils.fillArray(this, info.getIndex());
            return super.set(info.getIndex(), NestedUtils.wrapValue(value, this::createNestedMap, this::createNestedList));
        }
        if (!info.isSpread()) {
            NestedUtils.fillArray(this, info.getIndex());
            Object rightValue = super.get(info.getIndex());
            if (!NestedUtils.applicableFor(rightValue, info.getRight())) {
                rightValue = NestedUtils.createApplicableCollection(info.getRight(), this::createNestedMap, this::createNestedList);
                super.set(info.getIndex(), rightValue);
            }
            if (NestedUtils.applicableFor(rightValue, info.getRight(), NestedMap.class)) {
                return ((Map)rightValue).put(info.getRight(), value);
            }
            return ((NestedList)rightValue).put(info.getRight(), value);
        }
        ArrayList<Object> res = new ArrayList<Object>();
        if (value instanceof Iterable) {
            Iterable array = (Iterable)value;
            NestedUtils.fillArray(this, info.getIndex());
            Object rightValue = super.get(info.getIndex());
            if (!(rightValue instanceof NestedList)) {
                rightValue = this.createNestedList(null);
                super.set(info.getIndex(), rightValue);
            }
            int i = 0;
            for (Object o : array) {
                res.add(((NestedList)rightValue).put("[" + i + "]." + info.getRight(), o));
                ++i;
            }
            return res;
        }
        throw new IllegalArgumentException("Value must be iterable or array, but was " + value);
    }

    public Object removeByKey(Object oKey) {
        if (!(oKey instanceof String)) {
            throw new IllegalArgumentException("Argument must be String, but was " + oKey);
        }
        String key = (String)oKey;
        KeyInfo info = NestedList.getKeyInfo(key);
        if (!info.isNesting()) {
            if (this.size() > info.getIndex()) {
                return super.remove(info.getIndex());
            }
            return null;
        }
        if (!info.isSpread()) {
            Object rightValue;
            Object v0 = rightValue = this.size() > info.getIndex() ? super.get(info.getIndex()) : null;
            if (!NestedUtils.applicableFor(rightValue, info.getRight())) {
                return null;
            }
            if (NestedUtils.applicableFor(rightValue, info.getRight(), NestedMap.class)) {
                return ((Map)rightValue).remove(info.getRight());
            }
            return ((NestedList)rightValue).removeByKey(info.getRight());
        }
        throw new IllegalArgumentException("Key for containsKey must not contain '*.', but was " + key);
    }

    protected NestedMap createNestedMap(Map map) {
        if (map != null) {
            return new NestedMap(map);
        }
        return new NestedMap();
    }

    protected NestedList createNestedList(List list) {
        if (list != null) {
            return new NestedList((Collection<?>)list);
        }
        return new NestedList();
    }

    private static KeyInfo getKeyInfo(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null");
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Key must not be empty");
        }
        if (!key.startsWith("[")) {
            throw new IllegalArgumentException("Key must start with '[', but was " + key);
        }
        boolean spread = false;
        int endBracket = key.indexOf(93);
        if (endBracket < 0) {
            throw new IllegalArgumentException("Key must contain ']', but was " + key);
        }
        String left = key.substring(0, endBracket + 1);
        String property = left.substring(1, left.length() - 1);
        if (!NestedUtils.isNumeric(property)) {
            throw new IllegalArgumentException("Key in bracket must be number, but was " + key);
        }
        int index = Integer.parseInt(property);
        if (endBracket == key.length() - 1) {
            return new KeyInfo(index);
        }
        String right = key.substring(endBracket + 1);
        if (right.startsWith("*.")) {
            spread = true;
            right = right.substring(1);
        }
        if (right.startsWith(".")) {
            char ch = (right = right.substring(1)).charAt(0);
            if (!Character.isJavaIdentifierStart(ch)) {
                throw new IllegalArgumentException("Key '" + right + "' must match the naming convention of java variables, but was " + key);
            }
        } else if (!right.startsWith("[")) {
            throw new IllegalArgumentException("Key after ']' must contain '.' or '*.' or '['");
        }
        return new KeyInfo(index, right, spread);
    }

    private static class KeyInfo {
        private int index;
        private String right;
        private boolean spread;

        KeyInfo(int index) {
            this.index = index;
        }

        KeyInfo(int index, String right, boolean spread) {
            this.index = index;
            this.right = right;
            this.spread = spread;
        }

        boolean isNesting() {
            return this.right != null;
        }

        boolean isSpread() {
            return this.spread;
        }

        String getRight() {
            return this.right;
        }

        int getIndex() {
            return this.index;
        }
    }
}

