/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.criteria.dataset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.n2oapp.criteria.dataset.NestedList;
import net.n2oapp.criteria.dataset.NestedUtils;

public class NestedMap
extends LinkedHashMap<String, Object> {
    private static final char SPREAD_OPERAND = '*';

    public NestedMap() {
    }

    public NestedMap(Map<? extends String, ?> m) {
        this.putAll(m);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        for (String string : m.keySet()) {
            this.put(NestedUtils.wrapKey(string), m.get(string));
        }
    }

    @Override
    public boolean containsKey(Object oKey) {
        if (!(oKey instanceof String)) {
            throw new IllegalArgumentException("Key must be String, but was " + oKey);
        }
        String key = (String)oKey;
        KeyInfo info = NestedMap.getKeyInfo(key);
        Object value = super.get(info.getProperty());
        if (value == null) {
            return super.containsKey(info.getProperty());
        }
        if (!info.isNesting()) {
            return true;
        }
        if (!info.isSpread()) {
            if (NestedUtils.applicableFor(value, info.getRight(), Map.class)) {
                return ((Map)value).containsKey(info.getRight());
            }
            if (NestedUtils.applicableFor(value, info.getRight(), NestedList.class)) {
                return ((NestedList)value).get(info.getRight()) != null;
            }
            return false;
        }
        throw new IllegalArgumentException("Key for containsKey must not contain '*.', but was " + key);
    }

    @Override
    public Object get(Object oKey) {
        if (!(oKey instanceof String)) {
            throw new IllegalArgumentException("Key must be String, but was " + oKey);
        }
        String key = (String)oKey;
        KeyInfo info = NestedMap.getKeyInfo(key);
        Object value = super.get(info.getProperty());
        if (value == null) {
            return null;
        }
        if (!info.isNesting()) {
            return value;
        }
        if (!info.isSpread()) {
            if (NestedUtils.applicableFor(value, info.getRight(), Map.class)) {
                return ((Map)value).get(info.getRight());
            }
            if (NestedUtils.applicableFor(value, info.getRight(), NestedList.class)) {
                return ((NestedList)value).get(info.getRight());
            }
            return null;
        }
        if (!(value instanceof List)) {
            return null;
        }
        List array = (List)value;
        ArrayList<Object> result = new ArrayList<Object>(array.size());
        for (Object o : array) {
            Object child = null;
            if (o instanceof Map) {
                child = ((Map)o).get(info.getRight());
            }
            result.add(child);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Object put(String key, Object value) {
        KeyInfo info = NestedMap.getKeyInfo(key);
        if (!info.isNesting()) {
            return super.put(info.getProperty(), NestedUtils.wrapValue(value, this::createNestedMap, this::createNestedList));
        }
        if (!info.isSpread()) {
            Object rightValue = super.get(info.getProperty());
            if (!NestedUtils.applicableFor(rightValue, info.getRight())) {
                rightValue = NestedUtils.createApplicableCollection(info.getRight(), this::createNestedMap, this::createNestedList);
                super.put(info.getProperty(), rightValue);
            }
            if (NestedUtils.applicableFor(rightValue, info.getRight(), Map.class)) {
                return ((Map)rightValue).put(info.getRight(), value);
            }
            return ((NestedList)rightValue).put(info.getRight(), value);
        }
        ArrayList<Object> res = new ArrayList<Object>();
        if (value instanceof Iterable) {
            Iterable array = (Iterable)value;
            Object rightValue = super.get(info.getProperty());
            if (!(rightValue instanceof NestedList)) {
                rightValue = this.createNestedList(null);
                super.put(info.getProperty(), rightValue);
            }
            int i = 0;
            for (Object o : array) {
                res.add(((NestedList)rightValue).put("[" + i + "]." + info.getRight(), o));
                ++i;
            }
            return res;
        }
        throw new IllegalArgumentException("Value must be iterable or array, but was " + value);
    }

    @Override
    public Object remove(Object oKey) {
        if (!(oKey instanceof String)) {
            throw new IllegalArgumentException("Key must be String, but was " + oKey);
        }
        String key = (String)oKey;
        KeyInfo info = NestedMap.getKeyInfo(key);
        if (!info.isNesting()) {
            return super.remove(info.getProperty());
        }
        if (!info.isSpread()) {
            Object rightValue = super.get(info.getProperty());
            if (!NestedUtils.applicableFor(rightValue, info.getRight())) {
                return null;
            }
            if (NestedUtils.applicableFor(rightValue, info.getRight(), Map.class)) {
                return ((Map)rightValue).remove(info.getRight());
            }
            return ((NestedList)rightValue).removeByKey(info.getRight());
        }
        throw new IllegalArgumentException("Key for containsKey must not contain '*.', but was " + key);
    }

    protected NestedList createNestedList(List list) {
        if (list == null) {
            return new NestedList();
        }
        return new NestedList((Collection<?>)list);
    }

    protected NestedMap createNestedMap(Map map) {
        if (map == null) {
            return new NestedMap();
        }
        return new NestedMap(map);
    }

    private static KeyInfo getKeyInfo(String key) {
        String left;
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null");
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Key must not be empty");
        }
        String right = null;
        boolean spread = false;
        int endLeft = -1;
        if (key.startsWith("[")) {
            char quote = key.charAt(1);
            if (quote != '\'' && quote != '\"') {
                throw new IllegalArgumentException("Key in brackets must be in quotes, but was " + key);
            }
            int endQuote = key.indexOf(quote, 2);
            if (endQuote < 0) {
                throw new IllegalArgumentException("Key in brackets must started and finished in same quotes, but was " + key);
            }
            endLeft = key.indexOf(93, endQuote);
            if (endLeft < 0) {
                throw new IllegalArgumentException("Key must contain ']', but was " + key);
            }
            left = NestedUtils.decodeKey(key.substring(2, endLeft - 1));
            ++endLeft;
        } else {
            endLeft = NestedUtils.getEndOfWord(key);
            left = endLeft < 0 ? key : key.substring(0, endLeft);
            if (!NestedUtils.isJavaVariable(left)) {
                throw new IllegalArgumentException("Key '" + key + "' does not match the naming convention of java variables");
            }
        }
        if (endLeft < 0 || key.length() <= endLeft) {
            return new KeyInfo(left);
        }
        right = key.substring(endLeft);
        if (right.startsWith("*.")) {
            spread = true;
            if (!NestedUtils.isFirstJavaVariable(right = right.substring(2))) {
                throw new IllegalArgumentException("Key '" + right + "' does not match the naming convention of java variables");
            }
        } else if (right.startsWith(".")) {
            if (!NestedUtils.isFirstJavaVariable(right = right.substring(1))) {
                throw new IllegalArgumentException("Key '" + right + "' does not match the naming convention of java variables");
            }
        } else if (!right.startsWith("[")) {
            throw new IllegalArgumentException("Key must start with '[', but was " + right);
        }
        return new KeyInfo(left, right, spread);
    }

    private static class KeyInfo {
        private String property;
        private String right;
        private boolean spread;

        public KeyInfo(String property) {
            this.property = property;
        }

        KeyInfo(String property, String right, boolean spread) {
            this.property = property;
            this.right = right;
            this.spread = spread;
        }

        boolean isNesting() {
            return this.right != null;
        }

        boolean isSpread() {
            return this.spread;
        }

        String getRight() {
            return this.right;
        }

        String getProperty() {
            return this.property;
        }
    }
}

