/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.criteria.dataset;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.n2oapp.criteria.dataset.NestedList;
import net.n2oapp.criteria.dataset.NestedMap;

public abstract class NestedUtils {
    public static boolean isNumeric(String key) {
        int len = key.length();
        for (int i = 0; i < len; ++i) {
            char c = key.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean isJavaVariable(String key) {
        if (!Character.isJavaIdentifierStart(key.charAt(0))) {
            return false;
        }
        for (char c : key.toCharArray()) {
            if (Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNestedKey(String key) {
        int wordIdx = NestedUtils.getEndOfWord(key);
        if (!NestedUtils.isJavaVariable(key.substring(0, wordIdx))) {
            return false;
        }
        key = key.substring(wordIdx);
        return true;
    }

    public static boolean isFirstJavaVariable(String key) {
        int endOfWord = NestedUtils.getEndOfWord(key);
        String word = endOfWord < 0 ? key : key.substring(0, endOfWord);
        if (word.isEmpty()) {
            return false;
        }
        return NestedUtils.isJavaVariable(word);
    }

    public static int getEndOfWord(String key) {
        int endOfWord = -1;
        int dotIdx = key.indexOf(46);
        int spreadIdx = key.indexOf("*.");
        endOfWord = dotIdx < 0 && spreadIdx < 0 ? -1 : (dotIdx > 0 && spreadIdx < 0 ? dotIdx : (dotIdx < 0 && spreadIdx > 0 ? spreadIdx : Math.min(dotIdx, spreadIdx)));
        int bracketIdx = key.indexOf(91);
        endOfWord = endOfWord < 0 && bracketIdx < 0 ? -1 : (endOfWord > 0 && bracketIdx < 0 ? endOfWord : (endOfWord < 0 && bracketIdx > 0 ? bracketIdx : Math.min(endOfWord, bracketIdx)));
        return endOfWord;
    }

    public static void fillArray(List<Object> list, int idx) {
        for (int k = list.size(); k <= idx; ++k) {
            list.add(null);
        }
    }

    public static Object wrapValue(Object value, Function<? super Map, ? extends NestedMap> mapConstructor, Function<? super List, ? extends NestedList> listConstructor) {
        if (value instanceof NestedMap) {
            return mapConstructor.apply((NestedMap)value);
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            for (Object key : map.keySet()) {
                Object entryValue = map.get(key);
                Object entryWrap = NestedUtils.wrapValue(map.get(key), mapConstructor, listConstructor);
                if (entryWrap == entryValue) continue;
                map.put(key, entryWrap);
            }
            return mapConstructor.apply(map);
        }
        if (value instanceof List) {
            List list = (List)value;
            List result = listConstructor.apply(list);
            for (int k = 0; k < list.size(); ++k) {
                result.set(k, NestedUtils.wrapValue(list.get(k), mapConstructor, listConstructor));
            }
            value = result;
        }
        return value;
    }

    public static String encodeKey(String key) {
        return key.replace("'", "@27").replace("\"", "@22");
    }

    public static String decodeKey(String key) {
        return key.replace("@27", "'").replace("@22", "\"");
    }

    public static String wrapKey(String key) {
        if (key == null || key.isEmpty()) {
            return key;
        }
        return "['" + NestedUtils.encodeKey(key) + "']";
    }

    public static boolean applicableFor(Object value, String key) {
        return value != null && (Map.class.isAssignableFrom(value.getClass()) && NestedUtils.getAccessClass(key).equals(NestedMap.class) || NestedList.class.isAssignableFrom(value.getClass()) && NestedUtils.getAccessClass(key).equals(NestedList.class));
    }

    public static boolean applicableFor(Object value, String key, Class clazz) {
        return value != null && clazz.isAssignableFrom(value.getClass()) && clazz.isAssignableFrom(NestedUtils.getAccessClass(key));
    }

    public static Class<?> getAccessClass(String key) {
        if (key.startsWith("[") && !key.startsWith("['") && !key.startsWith("[\"")) {
            return NestedList.class;
        }
        return NestedMap.class;
    }

    public static Object createApplicableCollection(String key, Function<? super Map, ? extends NestedMap> mapConstructor, Function<? super List, ? extends NestedList> listConstructor) {
        if (NestedUtils.getAccessClass(key).equals(NestedList.class)) {
            return listConstructor.apply(null);
        }
        return mapConstructor.apply(null);
    }
}

