/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.criteria.dataset;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.n2oapp.criteria.api.CollectionPage;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.criteria.dataset.InstantiateArgumentException;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class DataSetMapper {
    private static final ExpressionParser writeParser = new SpelExpressionParser(new SpelParserConfiguration(true, true));
    private static final ExpressionParser readParser = new SpelExpressionParser(new SpelParserConfiguration(false, false));
    private static final Set<String> primitiveTypes = new HashSet<String>(Arrays.asList("java.lang.Boolean", "java.lang.Character", "java.lang.Byte", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.util.Date", "java.math.BigDecimal", "net.n2oapp.criteria.dataset.DataSet", "java.util.List"));
    private static final Predicate<String> MAPPING_PATTERN = Pattern.compile("\\['.+']").asPredicate();
    private static final String KEY_ERROR = "%s -> %s";

    public static Object[] map(DataSet dataSet, Map<String, String> mapping, String ... argumentClasses) {
        Object[] instances = DataSetMapper.instantiateArguments(argumentClasses);
        Object[] result = instances == null || instances.length == 0 ? new Object[mapping.size()] : instances;
        int idx = 0;
        for (Map.Entry<String, String> map : mapping.entrySet()) {
            Expression expression = writeParser.parseExpression(map.getValue() != null ? map.getValue() : "[" + idx + "]");
            expression.setValue((Object)result, dataSet.get(map.getKey()));
            ++idx;
        }
        return result;
    }

    public static Map<String, Object> mapToMap(DataSet dataSet, Map<String, String> mapping, Map<String, String> argumentClasses) {
        DataSetMapper.validateMapping(mapping);
        Map<String, Object> instances = DataSetMapper.instantiateArguments(argumentClasses);
        Map<String, Object> result = instances == null || instances.isEmpty() ? new DataSet() : instances;
        boolean idx = false;
        for (Map.Entry<String, String> map : mapping.entrySet()) {
            Expression expression = writeParser.parseExpression(map.getValue() != null ? map.getValue() : "['" + map.getKey() + "']");
            expression.setValue((Object)result, dataSet.get(map.getKey()));
        }
        return result;
    }

    public static DataSet extract(Object source, Map<String, String> fieldsMapping) {
        DataSet dataSet = new DataSet();
        for (Map.Entry<String, String> map : fieldsMapping.entrySet()) {
            Expression expression = readParser.parseExpression(map.getValue());
            Object value = expression.getValue(source);
            dataSet.put(map.getKey(), value);
        }
        return dataSet;
    }

    public static CollectionPage<DataSet> extract(CollectionPage<Object> sourceCollectionPage) {
        ArrayList<DataSet> page = new ArrayList<DataSet>(sourceCollectionPage.getCollection().size());
        BeanInfo info = null;
        for (Object value : sourceCollectionPage.getCollection()) {
            if (info == null) {
                try {
                    info = Introspector.getBeanInfo(value.getClass());
                }
                catch (IntrospectionException e) {
                    throw new RuntimeException(e);
                }
            }
            DataSet result = new DataSet();
            try {
                for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                    Method reader = pd.getReadMethod();
                    if (reader == null) continue;
                    result.put(pd.getName(), reader.invoke(value, new Object[0]));
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            page.add(result);
        }
        CollectionPage collectionPage = new CollectionPage();
        collectionPage.init(sourceCollectionPage.getCount(), page);
        return collectionPage;
    }

    private static Object[] instantiateArguments(String[] arguments) {
        if (arguments == null) {
            return null;
        }
        Object[] argumentInstances = new Object[arguments.length];
        for (int k = 0; k < arguments.length; ++k) {
            Class<?> argumentClass = null;
            if (primitiveTypes.contains(arguments[k])) {
                argumentInstances[k] = null;
                continue;
            }
            try {
                argumentClass = Class.forName(arguments[k]);
                argumentInstances[k] = argumentClass.newInstance();
                continue;
            }
            catch (Exception e) {
                throw new InstantiateArgumentException(arguments[k], e);
            }
        }
        return argumentInstances;
    }

    private static Map<String, Object> instantiateArguments(Map<String, String> arguments) {
        if (arguments == null) {
            return null;
        }
        LinkedHashMap<String, Object> argumentInstances = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, String> entry : arguments.entrySet()) {
            Class<?> argumentClass = null;
            try {
                argumentClass = Class.forName(entry.getValue());
                argumentInstances.put(entry.getKey(), argumentClass.newInstance());
            }
            catch (Exception e) {
                throw new InstantiateArgumentException(entry.getValue(), e);
            }
        }
        return argumentInstances;
    }

    private static void validateMapping(Map<String, String> mapping) {
        String errorMapping = mapping.entrySet().stream().filter(e -> e.getValue() != null).filter(e -> !MAPPING_PATTERN.test((String)e.getValue())).map(e -> String.format(KEY_ERROR, e.getKey(), e.getValue())).collect(Collectors.joining(", "));
        if (errorMapping != null && !errorMapping.isEmpty()) {
            throw new IllegalArgumentException("Not valid mapping: " + errorMapping);
        }
    }
}

