/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.engine.factory.integration.spring;

import java.util.Collection;
import java.util.Map;
import net.n2oapp.engine.factory.CachedEngineFactory;
import net.n2oapp.engine.factory.integration.spring.OverrideBean;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class SpringEngineFactory<T, G>
extends CachedEngineFactory<T, G>
implements ApplicationContextAware {
    private ApplicationContext context;

    protected SpringEngineFactory(ApplicationContext context) {
        this.context = context;
    }

    protected SpringEngineFactory() {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    @Override
    public Collection<G> findEngines() {
        Map beans = this.context.getBeansOfType(this.getEngineClass());
        return OverrideBean.removeOverriddenBeans(beans).values();
    }

    public abstract Class<G> getEngineClass();
}

