/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.access.integration.metadata.transform;

import net.n2oapp.framework.access.integration.metadata.transform.BaseAccessTransformer;
import net.n2oapp.framework.api.metadata.Compiled;
import net.n2oapp.framework.api.metadata.aware.PropertiesAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.meta.cell.ToolbarCell;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.AbstractButton;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.Group;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.PerformButton;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.Submenu;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import org.springframework.stereotype.Component;

@Component
public class ToolbarCellAccessTransformer
extends BaseAccessTransformer<ToolbarCell, CompileContext<?, ?>> {
    public ToolbarCell transform(ToolbarCell compiled, CompileContext<?, ?> context, CompileProcessor p) {
        MetaActions actions = (MetaActions)p.getScope(MetaActions.class);
        if (actions != null && compiled.getToolbar() != null) {
            for (Group group : compiled.getToolbar()) {
                for (AbstractButton b : group.getButtons()) {
                    if (b.getAction() != null) {
                        this.transfer((PropertiesAware)b.getAction(), (PropertiesAware)b);
                        continue;
                    }
                    if (!(b instanceof Submenu) || ((Submenu)b).getSubMenu() == null) continue;
                    for (PerformButton menuItem : ((Submenu)b).getSubMenu()) {
                        if (menuItem.getAction() == null) continue;
                        this.transfer((PropertiesAware)menuItem.getAction(), (PropertiesAware)menuItem);
                    }
                    this.merge((PropertiesAware)b, ((Submenu)b).getSubMenu());
                }
            }
        }
        return compiled;
    }

    public Class<? extends Compiled> getCompiledClass() {
        return ToolbarCell.class;
    }
}

