/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.access.metadata.schema.simple;

import net.n2oapp.criteria.filters.FilterType;
import net.n2oapp.framework.access.functions.StreamUtil;
import net.n2oapp.framework.access.metadata.accesspoint.AccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oObjectAccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oObjectFilter;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oObjectFiltersAccessPoint;
import net.n2oapp.framework.access.metadata.accesspoint.model.N2oPageAccessPoint;
import net.n2oapp.framework.access.metadata.schema.simple.N2oSimpleAccessSchema;
import net.n2oapp.framework.api.metadata.compile.SourceProcessor;
import net.n2oapp.framework.api.metadata.global.dao.object.N2oObject;
import net.n2oapp.framework.api.metadata.global.view.page.N2oPage;
import net.n2oapp.framework.api.metadata.validation.TypedMetadataValidator;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import org.springframework.stereotype.Component;

@Component
public class SimpleAccessSchemaValidator
extends TypedMetadataValidator<N2oSimpleAccessSchema> {
    public Class<N2oSimpleAccessSchema> getSourceClass() {
        return N2oSimpleAccessSchema.class;
    }

    public void validate(N2oSimpleAccessSchema metadata, SourceProcessor p) {
        StreamUtil.safeStreamOf(metadata.getN2oPermissions()).flatMap(ap -> p.safeStreamOf((Object[])ap.getAccessPoints())).forEach(ap -> this.validate((AccessPoint)ap, p));
        StreamUtil.safeStreamOf(metadata.getN2oRoles()).flatMap(ap -> StreamUtil.safeStreamOf(ap.getAccessPoints())).forEach(ap -> this.validate((AccessPoint)ap, p));
        StreamUtil.safeStreamOf(metadata.getN2oUserAccesses()).flatMap(ap -> p.safeStreamOf((Object[])ap.getAccessPoints())).forEach(ap -> this.validate((AccessPoint)ap, p));
        StreamUtil.safeStreamOf(metadata.getPermitAllPoints()).forEach(ap -> this.validate((AccessPoint)ap, p));
        StreamUtil.safeStreamOf(metadata.getAuthenticatedPoints()).forEach(ap -> this.validate((AccessPoint)ap, p));
    }

    private void validate(AccessPoint accessPoint, SourceProcessor processor) {
        if (accessPoint instanceof N2oObjectAccessPoint) {
            this.checkObjectAccess((N2oObjectAccessPoint)accessPoint, processor);
        }
        if (accessPoint instanceof N2oObjectFiltersAccessPoint) {
            this.checkObjectFiltersAccess((N2oObjectFiltersAccessPoint)accessPoint);
        }
        if (accessPoint instanceof N2oPageAccessPoint) {
            this.checkPageAccess((N2oPageAccessPoint)accessPoint, processor);
        }
    }

    private void checkObjectFiltersAccess(N2oObjectFiltersAccessPoint accessPoint) {
        if (accessPoint.getFilters() != null) {
            for (N2oObjectFilter f : accessPoint.getFilters()) {
                if (f.getFieldId() == null) {
                    throw new N2oMetadataValidationException("n2o.fieldIdNotSpecified").addData(new Object[]{accessPoint.getObjectId()});
                }
                if (f.getType() != null && f.getType().arity.equals((Object)FilterType.Arity.nullary) || f.getValueAttr() != null || f.getValues() != null && f.getValues().length >= 1) continue;
                throw new N2oMetadataValidationException("n2o.filterValueNotSpecified").addData(new Object[]{accessPoint.getObjectId()});
            }
        }
    }

    private void checkObjectAccess(N2oObjectAccessPoint accessPoint, SourceProcessor p) {
        p.checkNotNull((Object)accessPoint.getObjectId(), "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d object-id \u0432 object-access");
        p.checkForExists(accessPoint.getObjectId(), N2oObject.class, "\u041e\u0431\u044a\u0435\u043a\u0442 {0} \u0437\u0430\u0434\u0430\u043d\u043d\u044b\u0439 \u0432 object-access \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
    }

    private void checkPageAccess(N2oPageAccessPoint pageAccessPoint, SourceProcessor p) {
        p.checkNotNull((Object)pageAccessPoint.getPage(), "\u041d\u0435 \u0437\u0430\u0434\u0430\u043d page-id \u0432 page-access");
        p.checkForExists(pageAccessPoint.getPage(), N2oPage.class, "\u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430 {0} \u0437\u0430\u0434\u0430\u043d\u0430\u044f \u0432 page-access \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442");
    }
}

