/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.criteria;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.n2oapp.criteria.api.Criteria;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.criteria.Restriction;

public class N2oPreparedCriteria
extends Criteria {
    private List<Restriction> restrictions;
    private Map<String, Object> additionalFields;
    private Map<String, Object> attributes;

    public static N2oPreparedCriteria simpleCriteriaOneRecord(String fieldId, Object fieldValue) {
        return new N2oPreparedCriteria(fieldId, fieldValue, 1);
    }

    public N2oPreparedCriteria() {
    }

    public N2oPreparedCriteria(N2oPreparedCriteria base) {
        super((Criteria)base);
        this.restrictions = new ArrayList<Restriction>(base.getRestrictions());
        this.additionalFields = new LinkedHashMap<String, Object>(base.getAdditionalFields());
        this.attributes = new LinkedHashMap<String, Object>(base.getAttributes());
    }

    public N2oPreparedCriteria(String fieldId, Object fieldValue, int size) {
        this.setSize(size);
        this.setSortings(Collections.EMPTY_LIST);
        this.addRestriction(new Restriction(fieldId, fieldValue));
    }

    public Map<String, Object> getAdditionalFields() {
        if (this.additionalFields == null) {
            return Collections.emptyMap();
        }
        return this.additionalFields;
    }

    public void addRestriction(Restriction restriction) {
        if (this.restrictions == null) {
            this.restrictions = new ArrayList<Restriction>();
        }
        this.restrictions.add(restriction);
    }

    public List<Restriction> getRestrictions() {
        if (this.restrictions == null) {
            return Collections.emptyList();
        }
        return this.restrictions;
    }

    public Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.attributes);
    }

    public void putAdditionalField(String field, Object value) {
        if (this.additionalFields == null) {
            this.additionalFields = new LinkedHashMap<String, Object>();
        }
        this.additionalFields.put(field, value);
    }

    public void removeFilterForField(String fieldId) {
        if (this.restrictions != null) {
            for (Restriction restriction : new ArrayList<Restriction>(this.restrictions)) {
                if (!restriction.getFieldId().equals(fieldId)) continue;
                this.restrictions.remove((Object)restriction);
            }
        }
    }

    public void addRestrictions(List<Restriction> restrictions) {
        for (Restriction restriction : restrictions) {
            this.addRestriction(restriction);
        }
    }

    public boolean containsRestriction(String fieldId) {
        for (Restriction restriction : this.getRestrictions()) {
            if (!restriction.getFieldId().equals(fieldId)) continue;
            return true;
        }
        return false;
    }

    public List<Restriction> getRestrictions(String fieldId) {
        ArrayList<Restriction> res = new ArrayList<Restriction>();
        for (Restriction restriction : this.getRestrictions()) {
            if (!restriction.getFieldId().equals(fieldId)) continue;
            res.add(restriction);
        }
        return res;
    }

    public Object getAttribute(String attribute) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(attribute);
    }

    public void putAttribute(String attribute, Object value) {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap<String, Object>();
        }
        this.attributes.put(attribute, value);
    }

    public DataSet toDataSet() {
        DataSet dataSet = new DataSet();
        for (Restriction restriction : this.getRestrictions()) {
            dataSet.put(restriction.getFieldId(), restriction.getValue());
        }
        for (String field : this.getAdditionalFields().keySet()) {
            try {
                dataSet.put(field, this.getAdditionalFields().get(field));
            }
            catch (Exception exception) {}
        }
        return dataSet;
    }
}

