/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.data.validation;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptException;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.data.DomainProcessor;
import net.n2oapp.framework.api.data.InvocationProcessor;
import net.n2oapp.framework.api.data.validation.Validation;
import net.n2oapp.framework.api.data.validation.ValidationFailureCallback;
import net.n2oapp.framework.api.script.ScriptProcessor;

public class ConditionValidation
extends Validation {
    @JsonProperty
    private String expression;
    private String expressionOn;

    public ConditionValidation(ConditionValidation validation) {
        super(validation);
        this.expression = validation.getExpression();
        this.expressionOn = validation.getExpressionOn();
    }

    public void setExpression(String expression) {
        if (expression == null) {
            return;
        }
        this.expression = expression = expression.replaceAll("\n", "").replace("\r", "").trim();
    }

    private Set<String> getExpressionsOn() {
        HashSet<String> res = new HashSet<String>();
        if (this.expressionOn != null && this.expressionOn.length() > 0) {
            String[] expressions;
            for (String exp : expressions = this.expressionOn.split(",")) {
                res.add(exp.trim());
            }
        }
        return res;
    }

    @Override
    public void validate(DataSet dataSet, InvocationProcessor serviceProvider, ValidationFailureCallback callback) {
        try {
            DataSet copiedDataSet = new DataSet((Map)dataSet);
            for (String key : this.getExpressionsOn()) {
                Object value = dataSet.get((Object)key);
                if (!(value instanceof Date)) continue;
                copiedDataSet.put(key, (Object)DomainProcessor.getInstance().serialize(value));
            }
            ScriptProcessor.getInstance();
            if (!((Boolean)ScriptProcessor.eval(this.getExpression(), copiedDataSet)).booleanValue()) {
                callback.onFail(this.getMessage());
            }
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getType() {
        return "condition";
    }

    public String getExpression() {
        return this.expression;
    }

    public String getExpressionOn() {
        return this.expressionOn;
    }

    public void setExpressionOn(String expressionOn) {
        this.expressionOn = expressionOn;
    }

    public ConditionValidation() {
    }
}

