/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.data.validation;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.data.InvocationProcessor;
import net.n2oapp.framework.api.data.validation.ValidationFailureCallback;
import net.n2oapp.framework.api.exception.SeverityType;
import net.n2oapp.framework.api.metadata.Compiled;
import net.n2oapp.framework.api.metadata.control.N2oFieldCondition;
import net.n2oapp.framework.api.metadata.control.ValidationReference;
import net.n2oapp.framework.api.metadata.global.dao.validation.N2oValidation;

public abstract class Validation
implements Compiled {
    @JsonProperty(value="validationKey")
    private String id;
    @JsonProperty(value="text")
    private String message;
    private Set<String> fields;
    private ValidationReference.Target target;
    @JsonProperty
    private SeverityType severity = SeverityType.danger;
    private N2oValidation.ServerMoment moment;
    private String side;
    private Boolean enabled;
    private List<String> enablingConditions;
    private String fieldId;
    private N2oFieldCondition fieldVisibilityCondition;
    private String fieldSetVisibilityCondition;

    public Validation(Validation validation) {
        this.id = validation.getId();
        this.message = validation.getMessage();
        this.fields = validation.getFields();
        this.target = validation.getTarget();
        this.severity = validation.getSeverity();
        this.moment = validation.getMoment();
        this.fieldId = validation.getFieldId();
        this.side = validation.getSide();
    }

    public void addEnablingCondition(String condition) {
        if (condition == null) {
            return;
        }
        if (this.enablingConditions == null) {
            this.enablingConditions = new ArrayList<String>();
        }
        this.enablingConditions.add(condition);
    }

    public void addEnablingConditions(Collection<String> conditions) {
        if (conditions == null) {
            return;
        }
        if (this.enablingConditions == null) {
            this.enablingConditions = new ArrayList<String>();
        }
        this.enablingConditions.addAll(conditions);
    }

    public Set<String> getRequiredFields() {
        return this.getFields();
    }

    public abstract void validate(DataSet var1, InvocationProcessor var2, ValidationFailureCallback var3);

    @JsonProperty(value="type")
    public abstract String getType();

    public boolean isForField() {
        return this.fieldId != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Validation)) {
            return false;
        }
        return Objects.equals(this.id, ((Validation)o).id);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String getId() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    public Set<String> getFields() {
        return this.fields;
    }

    public ValidationReference.Target getTarget() {
        return this.target;
    }

    public SeverityType getSeverity() {
        return this.severity;
    }

    public N2oValidation.ServerMoment getMoment() {
        return this.moment;
    }

    public String getSide() {
        return this.side;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public List<String> getEnablingConditions() {
        return this.enablingConditions;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public N2oFieldCondition getFieldVisibilityCondition() {
        return this.fieldVisibilityCondition;
    }

    public String getFieldSetVisibilityCondition() {
        return this.fieldSetVisibilityCondition;
    }

    @JsonProperty(value="validationKey")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="text")
    public void setMessage(String message) {
        this.message = message;
    }

    public void setFields(Set<String> fields) {
        this.fields = fields;
    }

    public void setTarget(ValidationReference.Target target) {
        this.target = target;
    }

    @JsonProperty
    public void setSeverity(SeverityType severity) {
        this.severity = severity;
    }

    public void setMoment(N2oValidation.ServerMoment moment) {
        this.moment = moment;
    }

    public void setSide(String side) {
        this.side = side;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setEnablingConditions(List<String> enablingConditions) {
        this.enablingConditions = enablingConditions;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public void setFieldVisibilityCondition(N2oFieldCondition fieldVisibilityCondition) {
        this.fieldVisibilityCondition = fieldVisibilityCondition;
    }

    public void setFieldSetVisibilityCondition(String fieldSetVisibilityCondition) {
        this.fieldSetVisibilityCondition = fieldSetVisibilityCondition;
    }

    public Validation() {
    }
}

