/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.metadata.global.dao;

import java.util.Objects;
import net.n2oapp.criteria.filters.FilterType;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;

public class N2oPreFilter
implements Source {
    private String fieldId;
    private String valueAttr;
    private String valuesAttr;
    private FilterType type;
    private String targetWidgetId;
    private String param;
    private Boolean routable;
    private String refPageId;
    private String refWidgetId;
    private ReduxModel refModel;
    private String[] valueList;
    private Boolean required;
    private Boolean resetOnChange;

    public N2oPreFilter() {
    }

    public N2oPreFilter(String fieldId, String value, FilterType type) {
        this.fieldId = fieldId;
        this.type = type;
        this.valueAttr = value;
    }

    public N2oPreFilter(String fieldId, String[] values, FilterType type) {
        this.fieldId = fieldId;
        this.type = type;
        this.valueList = values;
    }

    public String getRef() {
        return StringUtils.unwrapLink(this.getValue());
    }

    public void setRef(String ref) {
        this.valueAttr = Placeholders.ref(ref);
    }

    public boolean isRef() {
        return this.getRef() != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof N2oPreFilter)) {
            return false;
        }
        N2oPreFilter that = (N2oPreFilter)o;
        return Objects.equals(this.fieldId, that.fieldId) && Objects.equals(this.refWidgetId, that.refWidgetId) && this.refModel == that.refModel && this.type == that.type;
    }

    public boolean isBoolean() {
        return FilterType.isNull.equals((Object)this.getType()) || FilterType.isNotNull.equals((Object)this.getType());
    }

    public boolean isArray() {
        return this.getValues() != null && this.getValues().length != 0 || this.type.arity.equals((Object)FilterType.Arity.n_ary) && this.valueAttr != null;
    }

    public int hashCode() {
        return Objects.hash(this.fieldId, this.refWidgetId, this.refModel, this.type);
    }

    public String[] getValues() {
        if (this.valueList != null && this.valueList.length > 0) {
            return this.valueList;
        }
        if (this.type != null && this.type.arity.equals((Object)FilterType.Arity.n_ary) && this.valueAttr != null) {
            return new String[]{this.valueAttr};
        }
        return null;
    }

    public String getValue() {
        return this.valueAttr == null ? this.valuesAttr : this.valueAttr;
    }

    public String toString() {
        return "N2oPreFilter{fieldId='" + this.fieldId + "', type=" + this.type + "}";
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public String getValueAttr() {
        return this.valueAttr;
    }

    public String getValuesAttr() {
        return this.valuesAttr;
    }

    public FilterType getType() {
        return this.type;
    }

    public String getTargetWidgetId() {
        return this.targetWidgetId;
    }

    public String getParam() {
        return this.param;
    }

    public Boolean getRoutable() {
        return this.routable;
    }

    public String getRefPageId() {
        return this.refPageId;
    }

    public String getRefWidgetId() {
        return this.refWidgetId;
    }

    public ReduxModel getRefModel() {
        return this.refModel;
    }

    public String[] getValueList() {
        return this.valueList;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public Boolean getResetOnChange() {
        return this.resetOnChange;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public void setValueAttr(String valueAttr) {
        this.valueAttr = valueAttr;
    }

    public void setValuesAttr(String valuesAttr) {
        this.valuesAttr = valuesAttr;
    }

    public void setType(FilterType type) {
        this.type = type;
    }

    public void setTargetWidgetId(String targetWidgetId) {
        this.targetWidgetId = targetWidgetId;
    }

    public void setParam(String param) {
        this.param = param;
    }

    public void setRoutable(Boolean routable) {
        this.routable = routable;
    }

    public void setRefPageId(String refPageId) {
        this.refPageId = refPageId;
    }

    public void setRefWidgetId(String refWidgetId) {
        this.refWidgetId = refWidgetId;
    }

    public void setRefModel(ReduxModel refModel) {
        this.refModel = refModel;
    }

    public void setValueList(String[] valueList) {
        this.valueList = valueList;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public void setResetOnChange(Boolean resetOnChange) {
        this.resetOnChange = resetOnChange;
    }
}

