/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.metadata.meta.widget;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.n2oapp.framework.api.data.validation.Validation;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.Component;
import net.n2oapp.framework.api.metadata.event.action.UploadType;
import net.n2oapp.framework.api.metadata.meta.ClientDataProvider;
import net.n2oapp.framework.api.metadata.meta.Filter;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.action.Action;
import net.n2oapp.framework.api.metadata.meta.toolbar.Toolbar;
import net.n2oapp.framework.api.metadata.meta.widget.WidgetComponent;
import net.n2oapp.framework.api.metadata.meta.widget.WidgetDependency;

public abstract class Widget<T extends WidgetComponent>
extends Component {
    @JsonProperty
    private String id;
    private String route;
    private String masterParam;
    private ModelLink masterLink;
    private String name;
    @JsonProperty
    private String icon;
    private UploadType upload;
    private String objectId;
    private String queryId;
    private String filtersDefaultValuesQueryId;
    private List<Filter> filters;
    protected T component;
    private Set<String> notCopiedFields;
    private List<Validation> validations = new ArrayList<Validation>();
    @JsonProperty
    private ClientDataProvider dataProvider;
    @JsonProperty
    private Toolbar toolbar;
    @JsonProperty
    @Deprecated
    private Map<String, Action> actions;
    @JsonProperty
    private WidgetDependency dependency;
    @JsonProperty
    private Boolean visible;

    public Widget() {
    }

    public Widget(T component) {
        this.component = component;
    }

    public Filter getFilter(String filterId) {
        if (this.filters == null) {
            return null;
        }
        return this.filters.stream().filter(f -> f.getFilterId().equals(filterId)).findFirst().orElseThrow(() -> new N2oException("Filter " + filterId + " not found"));
    }

    public boolean containsFilter(String filterId) {
        return this.filters != null && this.filters.stream().anyMatch(f -> f.getFilterId().equals(filterId));
    }

    public String getId() {
        return this.id;
    }

    public String getRoute() {
        return this.route;
    }

    public String getMasterParam() {
        return this.masterParam;
    }

    public ModelLink getMasterLink() {
        return this.masterLink;
    }

    public String getName() {
        return this.name;
    }

    public String getIcon() {
        return this.icon;
    }

    public UploadType getUpload() {
        return this.upload;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public String getFiltersDefaultValuesQueryId() {
        return this.filtersDefaultValuesQueryId;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public T getComponent() {
        return this.component;
    }

    public Set<String> getNotCopiedFields() {
        return this.notCopiedFields;
    }

    public List<Validation> getValidations() {
        return this.validations;
    }

    public ClientDataProvider getDataProvider() {
        return this.dataProvider;
    }

    public Toolbar getToolbar() {
        return this.toolbar;
    }

    @Deprecated
    public Map<String, Action> getActions() {
        return this.actions;
    }

    public WidgetDependency getDependency() {
        return this.dependency;
    }

    public Boolean getVisible() {
        return this.visible;
    }

    @JsonProperty
    public void setId(String id) {
        this.id = id;
    }

    public void setRoute(String route) {
        this.route = route;
    }

    public void setMasterParam(String masterParam) {
        this.masterParam = masterParam;
    }

    public void setMasterLink(ModelLink masterLink) {
        this.masterLink = masterLink;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty
    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setUpload(UploadType upload) {
        this.upload = upload;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public void setFiltersDefaultValuesQueryId(String filtersDefaultValuesQueryId) {
        this.filtersDefaultValuesQueryId = filtersDefaultValuesQueryId;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public void setComponent(T component) {
        this.component = component;
    }

    public void setNotCopiedFields(Set<String> notCopiedFields) {
        this.notCopiedFields = notCopiedFields;
    }

    public void setValidations(List<Validation> validations) {
        this.validations = validations;
    }

    @JsonProperty
    public void setDataProvider(ClientDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    @JsonProperty
    public void setToolbar(Toolbar toolbar) {
        this.toolbar = toolbar;
    }

    @Deprecated
    @JsonProperty
    public void setActions(Map<String, Action> actions) {
        this.actions = actions;
    }

    @JsonProperty
    public void setDependency(WidgetDependency dependency) {
        this.dependency = dependency;
    }

    @JsonProperty
    public void setVisible(Boolean visible) {
        this.visible = visible;
    }
}

