/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.util.async;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class MultiThreadRunner {
    private int threadMax = 50;
    private int timeout = 1;

    public MultiThreadRunner() {
    }

    public MultiThreadRunner(int threadMax, int timeout) {
        this.threadMax = threadMax;
        this.timeout = timeout;
    }

    public int run(Callable<Boolean> callable) throws InterruptedException, ExecutionException {
        ExecutorService executor = Executors.newCachedThreadPool();
        ArrayList<Future<Boolean>> results = new ArrayList<Future<Boolean>>();
        for (int i = 0; i < this.threadMax; ++i) {
            results.add(executor.submit(callable));
        }
        int miscalculations = 0;
        for (Future future : results) {
            Boolean res = (Boolean)future.get();
            if (res.booleanValue()) continue;
            System.out.println("Incorrect result, expected [true], but got [false]'");
            ++miscalculations;
        }
        executor.awaitTermination(this.timeout, TimeUnit.SECONDS);
        executor.shutdownNow();
        System.out.println("Overall: " + miscalculations + " wrong values.");
        return miscalculations;
    }
}

