/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.bean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.n2oapp.framework.api.bean.BeansOrderException;
import net.n2oapp.framework.api.bean.LocatedBean;
import net.n2oapp.framework.api.bean.LocatedBeanPack;

public class BeansSorting {
    public static <T extends LocatedBean> List<T> sort(List<T> list, List<LocatedBeanPack<T>> packs) throws BeansOrderException {
        List fullList = new ArrayList<Object>();
        fullList.addAll(list);
        fullList.addAll(packs);
        fullList = BeansSorting.sort(fullList);
        ArrayList<Object> result = new ArrayList<Object>();
        for (LocatedBean orderedBean : fullList) {
            if (orderedBean instanceof LocatedBeanPack) {
                result.addAll(((LocatedBeanPack)orderedBean).getPack());
                continue;
            }
            result.add(orderedBean);
        }
        return result;
    }

    public static <T extends LocatedBean> List<T> sort(List<T> inCollection) throws BeansOrderException {
        HashMap<LocatedBean, List> orderMap = new HashMap<LocatedBean, List>();
        ArrayList res = new ArrayList();
        ArrayList stack = new ArrayList();
        for (LocatedBean n2oModule : inCollection) {
            List<LocatedBean> after = BeansSorting.getAfterBeans(n2oModule);
            List<LocatedBean> before = BeansSorting.getBeforeBeans(n2oModule);
            BeansSorting.put(n2oModule, after, orderMap);
            for (LocatedBean next : before) {
                BeansSorting.put(next, Arrays.asList(n2oModule), orderMap);
            }
        }
        LinkedList tmp1 = new LinkedList();
        LinkedList tmp2 = new LinkedList();
        for (Map.Entry entry : orderMap.entrySet()) {
            if (((LocatedBean)entry.getKey()).isBeforeAll()) {
                tmp1.addFirst(entry);
                continue;
            }
            if (((LocatedBean)entry.getKey()).isAfterAll()) {
                tmp2.add(entry);
                continue;
            }
            tmp1.addLast(entry);
        }
        orderMap = new LinkedHashMap();
        for (Map.Entry entry : tmp1) {
            orderMap.put((LocatedBean)entry.getKey(), (List)entry.getValue());
        }
        for (Map.Entry entry : tmp2) {
            orderMap.put((LocatedBean)entry.getKey(), (List)entry.getValue());
        }
        for (Map.Entry entry : orderMap.entrySet()) {
            BeansSorting.addToRes((LocatedBean)entry.getKey(), orderMap, stack, res);
        }
        return res;
    }

    private static <T extends LocatedBean> List<T> getBeforeBeans(T n2oModule) {
        if (n2oModule.getNextBeans() == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(n2oModule.getNextBeans());
    }

    private static <T extends LocatedBean> List<T> getAfterBeans(T n2oModule) {
        if (n2oModule.getPrevBeans() == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(n2oModule.getPrevBeans());
    }

    private static <T extends LocatedBean> void addToRes(T key, Map<T, List<T>> orderMap, List<T> stack, List<T> res) throws BeansOrderException {
        if (stack.contains(key)) {
            throw new BeansOrderException();
        }
        stack.add(key);
        for (LocatedBean module : orderMap.get(key)) {
            if (res.contains(key)) continue;
            BeansSorting.addToRes(module, orderMap, stack, res);
        }
        if (!res.contains(key)) {
            res.add(key);
        }
        stack.remove(key);
    }

    private static <T extends LocatedBean> void put(T n2oModule, List<T> list, Map<T, List<T>> orderMap) {
        List<T> res = orderMap.get(n2oModule);
        if (res == null) {
            res = new ArrayList<T>(list);
        } else {
            res.addAll(list);
        }
        orderMap.put(n2oModule, res);
    }
}

