/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.metadata.control;

import java.util.Arrays;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.IdAware;
import net.n2oapp.framework.api.metadata.aware.PreFiltersAware;
import net.n2oapp.framework.api.metadata.control.N2oComponent;
import net.n2oapp.framework.api.metadata.global.dao.N2oPreFilter;
import net.n2oapp.framework.api.metadata.global.dao.validation.N2oValidation;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oToolbar;

public abstract class N2oField
extends N2oComponent
implements IdAware {
    private String id;
    private String visible;
    private String required;
    private String enabled;
    private String[] dependsOn;
    private String label;
    private String labelClass;
    @Deprecated
    private String labelStyle;
    private String description;
    private String help;
    private String domain;
    private Boolean noLabel;
    private Boolean noLabelBlock;
    private Validations validations;
    private Boolean copied;
    private String defaultValue;
    private String param;
    private ReduxModel refModel;
    private Page refPage;
    private String refWidgetId;
    private String refFieldId;
    private N2oToolbar toolbar;
    private Dependency[] dependencies;

    public void addDependency(Dependency d) {
        if (d == null) {
            return;
        }
        if (this.dependencies == null) {
            this.dependencies = new Dependency[1];
            this.dependencies[0] = d;
        } else {
            this.dependencies = Arrays.copyOf(this.dependencies, this.dependencies.length + 1);
            this.dependencies[this.dependencies.length - 1] = d;
        }
    }

    public void addDependencies(Dependency[] d) {
        if (d == null || d.length == 0) {
            return;
        }
        if (this.dependencies == null) {
            this.dependencies = new Dependency[d.length];
            this.dependencies = Arrays.copyOfRange(d, 0, d.length);
        } else {
            this.dependencies = Arrays.copyOf(this.dependencies, this.dependencies.length + d.length);
            System.arraycopy(d, 0, this.dependencies, this.dependencies.length, d.length);
        }
    }

    public boolean containsDependency(Class<? extends Dependency> clazz) {
        if (this.dependencies == null) {
            return false;
        }
        for (Dependency dependency : this.dependencies) {
            if (!dependency.getClass().equals(clazz)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getId() + ")";
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getVisible() {
        return this.visible;
    }

    public String getRequired() {
        return this.required;
    }

    public String getEnabled() {
        return this.enabled;
    }

    public String[] getDependsOn() {
        return this.dependsOn;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLabelClass() {
        return this.labelClass;
    }

    @Deprecated
    public String getLabelStyle() {
        return this.labelStyle;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHelp() {
        return this.help;
    }

    public String getDomain() {
        return this.domain;
    }

    public Boolean getNoLabel() {
        return this.noLabel;
    }

    public Boolean getNoLabelBlock() {
        return this.noLabelBlock;
    }

    public Validations getValidations() {
        return this.validations;
    }

    public Boolean getCopied() {
        return this.copied;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getParam() {
        return this.param;
    }

    public ReduxModel getRefModel() {
        return this.refModel;
    }

    public Page getRefPage() {
        return this.refPage;
    }

    public String getRefWidgetId() {
        return this.refWidgetId;
    }

    public String getRefFieldId() {
        return this.refFieldId;
    }

    public N2oToolbar getToolbar() {
        return this.toolbar;
    }

    public Dependency[] getDependencies() {
        return this.dependencies;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public void setVisible(String visible) {
        this.visible = visible;
    }

    public void setRequired(String required) {
        this.required = required;
    }

    public void setEnabled(String enabled) {
        this.enabled = enabled;
    }

    public void setDependsOn(String[] dependsOn) {
        this.dependsOn = dependsOn;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setLabelClass(String labelClass) {
        this.labelClass = labelClass;
    }

    @Deprecated
    public void setLabelStyle(String labelStyle) {
        this.labelStyle = labelStyle;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setNoLabel(Boolean noLabel) {
        this.noLabel = noLabel;
    }

    public void setNoLabelBlock(Boolean noLabelBlock) {
        this.noLabelBlock = noLabelBlock;
    }

    public void setValidations(Validations validations) {
        this.validations = validations;
    }

    public void setCopied(Boolean copied) {
        this.copied = copied;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setParam(String param) {
        this.param = param;
    }

    public void setRefModel(ReduxModel refModel) {
        this.refModel = refModel;
    }

    public void setRefPage(Page refPage) {
        this.refPage = refPage;
    }

    public void setRefWidgetId(String refWidgetId) {
        this.refWidgetId = refWidgetId;
    }

    public void setRefFieldId(String refFieldId) {
        this.refFieldId = refFieldId;
    }

    public void setToolbar(N2oToolbar toolbar) {
        this.toolbar = toolbar;
    }

    public void setDependencies(Dependency[] dependencies) {
        this.dependencies = dependencies;
    }

    public static class VisibilityDependency
    extends Dependency {
        private Boolean reset;

        public Boolean getReset() {
            return this.reset;
        }

        public void setReset(Boolean reset) {
            this.reset = reset;
        }
    }

    public static class FetchValueDependency
    extends Dependency
    implements PreFiltersAware {
        private String queryId;
        private String valueFieldId;
        private N2oPreFilter[] preFilters;
        private Integer size;

        public String getQueryId() {
            return this.queryId;
        }

        public String getValueFieldId() {
            return this.valueFieldId;
        }

        @Override
        public N2oPreFilter[] getPreFilters() {
            return this.preFilters;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        public void setValueFieldId(String valueFieldId) {
            this.valueFieldId = valueFieldId;
        }

        @Override
        public void setPreFilters(N2oPreFilter[] preFilters) {
            this.preFilters = preFilters;
        }

        public void setSize(Integer size) {
            this.size = size;
        }
    }

    public static class ResetDependency
    extends Dependency {
    }

    public static class FetchDependency
    extends Dependency {
    }

    public static class SetValueDependency
    extends Dependency {
    }

    public static class RequiringDependency
    extends Dependency {
    }

    public static class EnablingDependency
    extends Dependency {
    }

    public static class Dependency
    implements Source {
        private String[] on;
        private String value;
        private Boolean applyOnInit;

        public String[] getOn() {
            return this.on;
        }

        public String getValue() {
            return this.value;
        }

        public Boolean getApplyOnInit() {
            return this.applyOnInit;
        }

        public void setOn(String[] on) {
            this.on = on;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setApplyOnInit(Boolean applyOnInit) {
            this.applyOnInit = applyOnInit;
        }
    }

    public static enum Page implements IdAware
    {
        THIS{

            @Override
            public String getId() {
                return "this";
            }
        }
        ,
        PARENT{

            @Override
            public String getId() {
                return "parent";
            }
        };


        @Override
        public void setId(String id) {
        }
    }

    public static class Validations
    implements Source {
        private N2oValidation[] inlineValidations;
        private String[] whiteList;

        public N2oValidation[] getInlineValidations() {
            return this.inlineValidations;
        }

        public String[] getWhiteList() {
            return this.whiteList;
        }

        public void setInlineValidations(N2oValidation[] inlineValidations) {
            this.inlineValidations = inlineValidations;
        }

        public void setWhiteList(String[] whiteList) {
            this.whiteList = whiteList;
        }
    }
}

