/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.metadata.global.view.page;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.n2oapp.framework.api.metadata.Compiled;
import net.n2oapp.framework.api.metadata.Itemable;
import net.n2oapp.framework.api.metadata.SourceComponent;
import net.n2oapp.framework.api.metadata.global.view.region.N2oRegion;
import net.n2oapp.framework.api.metadata.global.view.region.N2oTabsRegion;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oWidget;
import net.n2oapp.framework.api.metadata.meta.page.StandardPage;
import net.n2oapp.framework.api.metadata.meta.region.Region;
import net.n2oapp.framework.api.metadata.meta.region.RegionItem;
import net.n2oapp.framework.api.metadata.meta.widget.Widget;

public class BasePageUtil {
    public static List<Widget<?>> getCompiledWidgets(StandardPage page) {
        List regions = page.getRegions().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        return new ArrayList(BasePageUtil.getRegionWidgets(regions));
    }

    private static List<Widget<?>> getRegionWidgets(List<? extends Compiled> items) {
        ArrayList widgets = new ArrayList();
        for (Compiled compiled : items) {
            if (compiled instanceof Widget) {
                widgets.add((Widget)compiled);
                continue;
            }
            if (compiled instanceof Itemable) {
                Itemable region = (Itemable)((Object)compiled);
                if (region.getItems() == null) continue;
                for (RegionItem regionItem : region.getItems()) {
                    widgets.addAll(BasePageUtil.getRegionWidgets(regionItem.getContent()));
                }
                continue;
            }
            if (!(compiled instanceof Region) || ((Region)compiled).getContent() == null) continue;
            widgets.addAll(BasePageUtil.getRegionWidgets(((Region)compiled).getContent()));
        }
        return widgets;
    }

    public static List<N2oWidget> collectWidgets(SourceComponent[] items) {
        ArrayList<N2oWidget> widgets = new ArrayList<N2oWidget>();
        if (items != null && items.length != 0) {
            BasePageUtil.resolveRegionItems(items, item -> widgets.addAll(BasePageUtil.collectWidgets(item.getContent())), item -> {
                if (item.getTabs() != null) {
                    for (N2oTabsRegion.Tab tab : item.getTabs()) {
                        if (tab.getContent() == null) continue;
                        widgets.addAll(BasePageUtil.collectWidgets(tab.getContent()));
                    }
                }
            }, widgets::add);
        }
        return widgets;
    }

    public static void resolveRegionItems(SourceComponent[] items, Consumer<N2oRegion> regionConsumer, Consumer<N2oWidget> widgetConsumer) {
        for (SourceComponent item : items) {
            if (item instanceof N2oWidget) {
                widgetConsumer.accept((N2oWidget)item);
                continue;
            }
            if (!(item instanceof N2oRegion)) continue;
            regionConsumer.accept((N2oRegion)item);
        }
    }

    public static void resolveRegionItems(SourceComponent[] items, Consumer<N2oRegion> regionConsumer, Consumer<N2oTabsRegion> tabsRegionConsumer, Consumer<N2oWidget> widgetConsumer) {
        for (SourceComponent item : items) {
            if (item instanceof N2oWidget) {
                widgetConsumer.accept((N2oWidget)item);
                continue;
            }
            if (item instanceof N2oTabsRegion) {
                tabsRegionConsumer.accept((N2oTabsRegion)item);
                continue;
            }
            if (!(item instanceof N2oRegion)) continue;
            regionConsumer.accept((N2oRegion)item);
        }
    }
}

