/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.metadata.local.view.widget.control;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.n2oapp.framework.api.metadata.control.N2oField;
import net.n2oapp.framework.api.metadata.control.N2oListField;
import net.n2oapp.framework.api.metadata.control.interval.N2oSimpleIntervalField;
import net.n2oapp.framework.api.metadata.control.plain.N2oPlainField;

public class ControlModelBinder {
    private Collection<N2oField> controls;

    public ControlModelBinder(Collection<N2oField> controls) {
        this.controls = controls;
    }

    public List<N2oField> bind(String modelField) {
        ArrayList<N2oField> res = new ArrayList<N2oField>();
        this.bindPlainControls(modelField, res);
        this.bindComplexControls(modelField, res);
        return res;
    }

    private void bindPlainControls(String modelField, List<N2oField> res) {
        for (N2oField field : this.controls) {
            if (!(field instanceof N2oPlainField) || !field.getId().equals(modelField)) continue;
            res.add(field);
        }
    }

    private void bindComplexControls(String modelField, List<N2oField> res) {
        String[] tmp = modelField.split("\\.");
        if (tmp.length <= 1) {
            return;
        }
        for (int i = 0; i < tmp.length - 1; ++i) {
            this.findListControl(res, this.trim(this.toString(Arrays.copyOfRange(tmp, 0, i + 1))));
        }
    }

    private String trim(String s) {
        if (s.endsWith("*")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    private void findListControl(List<N2oField> res, String controlId) {
        for (N2oField field : this.controls) {
            if (!field.getId().equals(controlId) || !(field instanceof N2oListField) && !(field instanceof N2oSimpleIntervalField)) continue;
            res.add(field);
        }
    }

    private String toString(String[] array) {
        StringBuilder res = new StringBuilder();
        boolean begin = true;
        for (int i = 0; i < array.length; ++i) {
            if (!begin) {
                res.append('.');
            }
            res.append(array[i]);
            begin = false;
        }
        return res.toString();
    }
}

