/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.exception.SeverityType;
import net.n2oapp.framework.api.metadata.global.view.page.N2oDialog;
import net.n2oapp.framework.api.ui.AlertMessageBuilder;
import net.n2oapp.framework.api.ui.RequestInfo;
import net.n2oapp.framework.api.ui.ResponseMessage;

public class ResponseInfo {
    private N2oDialog dialog;
    private List<ResponseMessage> messageList;
    private Map<String, Object> attributes;
    private boolean stackedMessages = false;
    private AlertMessageBuilder alertMessageBuilder;

    public ResponseMessage constructMessage(RequestInfo requestInfo, SeverityType severityType) {
        return this.alertMessageBuilder.buildMessage(requestInfo, severityType);
    }

    public void addMessage(ResponseMessage message) {
        if (this.messageList == null) {
            this.messageList = new ArrayList<ResponseMessage>();
        }
        this.messageList.add(message);
    }

    public void addAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap<String, Object>();
        }
        this.attributes.put(name, value);
    }

    public List<ResponseMessage> getMessageList() {
        return this.messageList != null ? this.messageList : Collections.emptyList();
    }

    public void prepare(DataSet dataset) {
        this.getMessageList().forEach(m -> {
            String msg = StringUtils.resolveLinks(m.getText(), dataset);
            m.setText(msg);
        });
    }

    public N2oDialog getDialog() {
        return this.dialog;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public boolean isStackedMessages() {
        return this.stackedMessages;
    }

    public AlertMessageBuilder getAlertMessageBuilder() {
        return this.alertMessageBuilder;
    }

    public void setDialog(N2oDialog dialog) {
        this.dialog = dialog;
    }

    public void setMessageList(List<ResponseMessage> messageList) {
        this.messageList = messageList;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public void setStackedMessages(boolean stackedMessages) {
        this.stackedMessages = stackedMessages;
    }

    public void setAlertMessageBuilder(AlertMessageBuilder alertMessageBuilder) {
        this.alertMessageBuilder = alertMessageBuilder;
    }
}

