/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import net.n2oapp.context.StaticSpringContext;
import net.n2oapp.framework.api.exception.N2oException;

public class JsonUtil {
    private static ObjectMapper mapper;

    public static void merge(ObjectNode mainNode, ObjectNode updateNode) {
        Iterator fieldNames = updateNode.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode jsonMainNode = mainNode.get(fieldName);
            JsonNode jsonUpdateNode = updateNode.get(fieldName);
            if (jsonMainNode != null && jsonMainNode.isObject() && jsonUpdateNode.isObject()) {
                JsonUtil.merge((ObjectNode)jsonMainNode, (ObjectNode)jsonUpdateNode);
                continue;
            }
            if (jsonMainNode != null && jsonMainNode.isArray() && jsonUpdateNode.isArray()) {
                JsonUtil.mergeArrays((ArrayNode)jsonMainNode, (ArrayNode)jsonUpdateNode);
                continue;
            }
            mainNode.put(fieldName, jsonUpdateNode);
        }
    }

    public static String getObjectAsJsonString(Object o) {
        try {
            return JsonUtil.getMapper().writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            throw new N2oException(e);
        }
    }

    public static ObjectMapper getMapper() {
        if (mapper == null) {
            JsonUtil.initMapper();
        }
        return mapper;
    }

    private static synchronized void initMapper() {
        if (mapper == null) {
            mapper = (ObjectMapper)StaticSpringContext.getBean((String)"n2oObjectMapper", ObjectMapper.class);
        }
    }

    public static void mergeArrays(ArrayNode mainArray, ArrayNode updateArray) {
        mainArray.addAll(updateArray);
    }
}

