/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.criteria;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.n2oapp.criteria.api.Criteria;
import net.n2oapp.criteria.api.Sorting;
import net.n2oapp.framework.api.criteria.expression.DisplayExpression;
import net.n2oapp.framework.api.criteria.expression.FilterExpression;
import net.n2oapp.framework.api.criteria.expression.JoinExpression;
import net.n2oapp.framework.api.criteria.expression.SortingExpression;
import net.n2oapp.framework.api.exception.N2oException;

public class N2oCriteria
extends Criteria {
    private Map<String, Object> filterDataSet;
    private List<FilterExpression> filterList;
    private List<DisplayExpression> displayList;
    private List<SortingExpression> sortingList;
    private List<JoinExpression> joinList;
    private Map<String, Object> attributes;

    public N2oCriteria() {
    }

    public N2oCriteria(Criteria criteria) {
        super(criteria);
    }

    public N2oCriteria(N2oCriteria criteria) {
        super((Criteria)criteria);
        this.filterList = criteria.filterList;
        this.filterDataSet = criteria.filterDataSet;
        this.displayList = criteria.displayList;
        this.sortingList = criteria.sortingList;
        this.joinList = criteria.joinList;
    }

    public List<DisplayExpression> getDisplayList() {
        if (this.displayList == null) {
            return Collections.emptyList();
        }
        return this.displayList;
    }

    public List<SortingExpression> getSortingList() {
        if (this.sortingList == null) {
            return Collections.emptyList();
        }
        return this.sortingList;
    }

    public Map<String, String> getDisplayMapping() {
        HashMap<String, String> res = new HashMap<String, String>();
        for (DisplayExpression display : this.getDisplayList()) {
            res.put(display.getFieldId(), display.getExpression());
        }
        return res;
    }

    public List<JoinExpression> getJoinList() {
        return this.joinList == null ? Collections.emptyList() : this.joinList;
    }

    public List<FilterExpression> getFilterList() {
        if (this.filterList == null) {
            return Collections.emptyList();
        }
        return this.filterList;
    }

    public Object getFilterValue(FilterExpression filter) {
        Object value = this.getFilterDataSet().get(filter.getFilterFieldId());
        if (value == null) {
            throw new N2oException("filter-value for " + filter.getFilterFieldId() + " is null");
        }
        return value;
    }

    public N2oCriteria addFilter(FilterExpression filter, Object value) {
        if (this.filterList == null) {
            this.filterList = new ArrayList<FilterExpression>();
        }
        this.filterList.add(filter);
        this.putFilterValue(filter.getFilterFieldId(), value);
        return this;
    }

    public Map<String, Object> getFilterDataSet() {
        if (this.filterDataSet == null) {
            return Collections.emptyMap();
        }
        return this.filterDataSet;
    }

    public N2oCriteria putFilterValue(String fieldId, Object value) {
        if (this.filterDataSet == null) {
            this.filterDataSet = new HashMap<String, Object>();
        }
        this.filterDataSet.put(fieldId, value);
        return this;
    }

    public N2oCriteria addDisplay(DisplayExpression display) {
        if (this.displayList == null) {
            this.displayList = new ArrayList<DisplayExpression>();
        }
        this.displayList.add(display);
        return this;
    }

    public N2oCriteria addSorting(SortingExpression sorting) {
        if (this.sortingList == null) {
            this.sortingList = new ArrayList<SortingExpression>();
        }
        this.sortingList.add(sorting);
        return this;
    }

    public N2oCriteria addJoin(JoinExpression join) {
        if (this.joinList == null) {
            this.joinList = new ArrayList<JoinExpression>();
        }
        this.joinList.add(join);
        return this;
    }

    public N2oCriteria setJoins(Collection<JoinExpression> joins) {
        if (this.joinList == null) {
            this.joinList = new ArrayList<JoinExpression>(joins);
        } else {
            this.joinList.addAll(joins);
        }
        return this;
    }

    public N2oCriteria putFilterValues(Map<String, Object> values) {
        for (String key : values.keySet()) {
            if (this.filterDataSet != null && this.filterDataSet.containsKey(key)) continue;
            this.putFilterValue(key, values.get(key));
        }
        return this;
    }

    public boolean byId() {
        for (FilterExpression filter : this.getFilterList()) {
            if (!filter.getFilterFieldId().equals("id")) continue;
            return true;
        }
        return false;
    }

    public void iterateFilters(FilterVisitor visitor) {
        for (FilterExpression filter : this.getFilterList()) {
            visitor.visit(filter, this.getFilterValue(filter));
        }
    }

    public void removeDisplay(String fieldId) {
        for (DisplayExpression displayExpression : new ArrayList<DisplayExpression>(this.getDisplayList())) {
            if (!fieldId.equals(displayExpression.getFieldId())) continue;
            this.getDisplayList().remove(new DisplayExpression(fieldId, null, null));
        }
    }

    public Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.attributes);
    }

    public Object getAttribute(String attribute) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(attribute);
    }

    public void putAttribute(String attribute, Object value) {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap<String, Object>();
        }
        this.attributes.put(attribute, value);
    }

    @Deprecated
    public void setSortings(List<Sorting> sortings) {
        super.setSortings(sortings);
    }

    @Deprecated
    public List<Sorting> getSortings() {
        return super.getSortings();
    }

    @Deprecated
    public void setSorting(Sorting sorting) {
        super.setSorting(sorting);
    }

    @Deprecated
    public Sorting getSorting() {
        return super.getSorting();
    }

    public static interface FilterVisitor {
        public void visit(FilterExpression var1, Object var2);
    }
}

