/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.data.validation;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.data.DomainProcessor;
import net.n2oapp.framework.api.data.InvocationProcessor;
import net.n2oapp.framework.api.data.validation.Validation;
import net.n2oapp.framework.api.data.validation.ValidationFailureCallback;
import net.n2oapp.framework.api.metadata.global.dao.invocation.model.N2oInvocation;
import net.n2oapp.framework.api.metadata.global.dao.object.AbstractParameter;
import net.n2oapp.framework.api.metadata.global.dao.object.InvocationParameter;

public class ConstraintValidation
extends Validation {
    private Set<String> requiredFields;
    private N2oInvocation invocation;
    private List<InvocationParameter> inParameterList;
    private List<InvocationParameter> outParametersList;

    public ConstraintValidation(ConstraintValidation validation) {
        super(validation);
        this.requiredFields = validation.getRequiredFields();
        this.invocation = validation.getInvocation();
        this.inParameterList = validation.getInParameterList();
        this.outParametersList = validation.getOutParametersList();
    }

    public void setInParameterList(List<InvocationParameter> inParameterList) {
        this.requiredFields = inParameterList.stream().filter(p -> p.getRequired() != null && p.getRequired() != false).map(AbstractParameter::getId).collect(Collectors.toSet());
        this.inParameterList = inParameterList;
    }

    @Override
    public void validate(DataSet dataSet, InvocationProcessor serviceProvider, ValidationFailureCallback callback) {
        dataSet = DomainProcessor.getInstance().doDomainConversation(dataSet, this.getInParameterList());
        DataSet result = serviceProvider.invoke(this.getInvocation(), dataSet, this.getInParameterList(), this.getOutParametersList());
        if (result.get((Object)"validation") == null || !((Boolean)result.get((Object)"validation")).booleanValue()) {
            callback.onFail(StringUtils.resolveLinks(this.getMessage(), result));
        }
    }

    @Override
    public String getType() {
        return "constraint";
    }

    @Override
    public Set<String> getRequiredFields() {
        return this.requiredFields;
    }

    public N2oInvocation getInvocation() {
        return this.invocation;
    }

    public List<InvocationParameter> getInParameterList() {
        return this.inParameterList;
    }

    public List<InvocationParameter> getOutParametersList() {
        return this.outParametersList;
    }

    public void setRequiredFields(Set<String> requiredFields) {
        this.requiredFields = requiredFields;
    }

    public void setInvocation(N2oInvocation invocation) {
        this.invocation = invocation;
    }

    public void setOutParametersList(List<InvocationParameter> outParametersList) {
        this.outParametersList = outParametersList;
    }

    public ConstraintValidation() {
    }
}

