/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api;

import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.n2oapp.framework.api.NotFoundPlaceholderException;
import net.n2oapp.framework.api.PlaceHoldersResolver;
import net.n2oapp.framework.api.context.Context;
import net.n2oapp.framework.api.exception.NotFoundContextPlaceholderException;

public abstract class StringUtils {
    private static PlaceHoldersResolver propertyPlaceHoldersResolver = new PlaceHoldersResolver("${", "}", new String[0]);
    private static PlaceHoldersResolver contextPlaceHoldersResolver = new PlaceHoldersResolver("#{", "}", new String[0]);
    private static PlaceHoldersResolver jsPlaceHoldersResolver = new PlaceHoldersResolver("`", "`", new String[0]);
    private static PlaceHoldersResolver linkPlaceHoldersResolver = new PlaceHoldersResolver("{", "}", new String[0]);
    private static final String PATTERN = "^([a-zA-Z$_][a-zA-Z0-9$_]*\\(\\))$";

    public static boolean isProperty(String s) {
        return propertyPlaceHoldersResolver.isPlaceHolder(s);
    }

    public static boolean hasProperty(String text) {
        return propertyPlaceHoldersResolver.hasPlaceHolders(text);
    }

    public static boolean isContext(String s) {
        return contextPlaceHoldersResolver.isPlaceHolder(s);
    }

    public static boolean hasContext(String text) {
        return contextPlaceHoldersResolver.hasPlaceHolders(text);
    }

    public static boolean isLink(Object value) {
        return linkPlaceHoldersResolver.isPlaceHolder(value) && ((String)value).matches("\\{[\\w.]+}");
    }

    public static boolean hasLink(String text) {
        return StringUtils.isLink(text) || linkPlaceHoldersResolver.hasPlaceHolders(text);
    }

    public static boolean isJs(Object s) {
        return s instanceof String && jsPlaceHoldersResolver.isPlaceHolder(s);
    }

    public static boolean isFunction(String s) {
        if (s == null) {
            return false;
        }
        Pattern p = Pattern.compile(PATTERN);
        Matcher m = p.matcher(s);
        return m.matches();
    }

    public static boolean isDynamicValue(Object value) {
        if (!(value instanceof String)) {
            return false;
        }
        String s = (String)value;
        return StringUtils.isJs(s) || StringUtils.isContext(s) || StringUtils.isLink(s) || StringUtils.isProperty(s) || StringUtils.isFunction(s);
    }

    public static String resolveProperties(String text, Object properties) {
        return propertyPlaceHoldersResolver.resolve(text, properties);
    }

    public static String resolveProperties(String text, Function<String, Object> properties) {
        return propertyPlaceHoldersResolver.resolve(text, properties);
    }

    public static String resolveContext(String text, Context context) {
        try {
            return contextPlaceHoldersResolver.resolve(text, PlaceHoldersResolver.replaceNullByEmpty(PlaceHoldersResolver.replaceOptional(context::get)));
        }
        catch (NotFoundPlaceholderException e) {
            throw new NotFoundContextPlaceholderException(e.getPlaceholder());
        }
    }

    public static String resolveLinks(String text, Object data) {
        return linkPlaceHoldersResolver.resolve(text, PlaceHoldersResolver.replaceNullByEmpty(data));
    }

    public static String resolveLinks(String text, Function<String, Object> data) {
        return linkPlaceHoldersResolver.resolve(text, PlaceHoldersResolver.replaceNullByEmpty(data));
    }

    public static Set<String> collectLinks(String text) {
        return linkPlaceHoldersResolver.extractPlaceHolders(text);
    }

    public static boolean maskMatch(String mask, String val) {
        return mask == null || val == null ? mask == null && val == null : val.matches(StringUtils.maskToRegex(mask));
    }

    public static String maskToRegex(String mask) {
        if (mask == null) {
            return null;
        }
        if (!mask.contains("*")) {
            return "\\Q" + mask + "\\E";
        }
        StringBuilder sb = new StringBuilder();
        if (mask.startsWith("*")) {
            sb.append("(.*)");
        }
        String[] pieces = mask.split("\\*");
        for (int i = 0; i < pieces.length; ++i) {
            if (pieces[i].isEmpty()) continue;
            sb.append("\\Q").append(pieces[i]).append("\\E");
            if (i + 1 >= pieces.length && !mask.endsWith("*")) continue;
            sb.append("(.*)");
        }
        return sb.toString();
    }
}

