/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.data;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.criteria.dataset.Interval;
import net.n2oapp.criteria.filters.FilterType;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.aware.IdAware;
import net.n2oapp.framework.api.metadata.domain.Domain;
import net.n2oapp.framework.api.metadata.global.dao.object.InvocationParameter;
import net.n2oapp.framework.api.metadata.local.CompiledObject;

public class DomainProcessor {
    private static DomainProcessor ourInstance = new DomainProcessor();
    private static final Map<Class, String> simpleDomainsMap = new HashMap<Class, String>();
    private final ObjectMapper objectMapper;
    private final String dateFormat;

    @Deprecated
    public static DomainProcessor getInstance() {
        return ourInstance;
    }

    public DomainProcessor(ObjectMapper objectMapper, String dateFormat) {
        this.objectMapper = objectMapper;
        this.dateFormat = dateFormat;
    }

    public DomainProcessor() {
        this.dateFormat = "dd.MM.yyyy HH:mm:ss";
        this.objectMapper = new ObjectMapper();
        this.objectMapper.setDateFormat((DateFormat)new SimpleDateFormat(this.dateFormat));
    }

    public Object deserialize(Object value, String domain) {
        if (value == null) {
            return null;
        }
        if (StringUtils.isDynamicValue(value)) {
            return value;
        }
        if (domain == null && (domain = this.findDomain(value)) == null) {
            return value;
        }
        if (this.isArray(domain = domain.toLowerCase())) {
            return this.convertArray(value, domain);
        }
        if (this.isInterval(domain)) {
            return this.convertInterval(value, domain);
        }
        return this.convertObject(value, domain);
    }

    public Object deserialize(Object value) {
        return this.deserialize(value, (String)null);
    }

    public Object deserialize(Object value, Class<?> clazz) {
        if (clazz.isEnum()) {
            return this.deserializeEnum(value, clazz);
        }
        String domain = simpleDomainsMap.get(clazz);
        Object object = this.deserialize(value, domain);
        if (object != null && !StringUtils.isDynamicValue(object) && !clazz.isAssignableFrom(object.getClass())) {
            throw new ClassCastException(String.format("Value [%s] is not a %s", value, clazz));
        }
        return object;
    }

    public <T extends Enum<T>> T deserializeEnum(Object value, Class<T> enumClass) {
        block6: {
            if (value == null) {
                return null;
            }
            if (enumClass.isAssignableFrom(value.getClass())) {
                return (T)((Enum)value);
            }
            if (!(value instanceof String)) break block6;
            String strValue = (String)value;
            boolean idAware = IdAware.class.isAssignableFrom(enumClass);
            if (idAware) {
                for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
                    IdAware idEnum = (IdAware)((Object)enumValue);
                    if (!idEnum.getId().equalsIgnoreCase(strValue)) continue;
                    return (T)enumValue;
                }
            } else {
                for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
                    if (!enumValue.name().equalsIgnoreCase(strValue)) continue;
                    return (T)enumValue;
                }
            }
        }
        return null;
    }

    public String serialize(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String || value instanceof Boolean) {
            return value.toString();
        }
        try {
            return this.objectMapper.writeValueAsString(value).replace("\"", "");
        }
        catch (JsonProcessingException e) {
            throw new N2oException(e);
        }
    }

    public DataSet domainConversionByAction(DataSet inDataSet, CompiledObject.Operation operation) {
        return this.doDomainConversation(inDataSet, operation.getInParametersMap().values());
    }

    public DataSet doDomainConversation(DataSet inDataSet, Collection<? extends InvocationParameter> values) {
        for (InvocationParameter invocationParameter : values) {
            String paramName = invocationParameter.getId();
            Object value = inDataSet.get((Object)paramName);
            if (value == null) continue;
            String domain = invocationParameter.getDomain();
            inDataSet.put(paramName, this.deserialize(value, domain));
        }
        return inDataSet;
    }

    @Deprecated
    public Object doDomainConversion(String domain, Object value) {
        return this.deserialize(value, domain);
    }

    private Object convertObject(Object value, String domain) {
        if (value instanceof String || value instanceof Number) {
            try {
                return this.toObject(domain, value.toString());
            }
            catch (IOException | ParseException e) {
                throw new IllegalStateException(String.format("failed to cast to type [%s] value [%s]", domain, value), e);
            }
        }
        return value;
    }

    private Interval<?> convertInterval(Object value, String domain) {
        Interval res = new Interval();
        Object begin = null;
        Object end = null;
        String domainElement = domain.replaceAll("interval\\{", "").replaceAll("\\}", "");
        if (value instanceof String && ((String)value).startsWith("{") && ((String)value).endsWith("}")) {
            try {
                value = this.objectMapper.readValue((String)value, Map.class);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        if (value instanceof Collection) {
            Iterator iterator = ((Collection)value).iterator();
            begin = iterator.hasNext() ? iterator.next() : null;
            end = iterator.hasNext() ? iterator.next() : null;
        } else if (value instanceof Map) {
            Map map = (Map)value;
            begin = map.getOrDefault("begin", map.get("from"));
            end = map.getOrDefault("end", map.get("to"));
        } else {
            throw new IllegalStateException("Value " + value + " is not an interval");
        }
        res.setBegin(this.deserialize(begin, domainElement));
        res.setEnd(this.deserialize(end, domainElement));
        return res;
    }

    private Object convertArray(Object value, String domain) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        String domainElement = domain.replaceAll("\\[\\]", "");
        if (value instanceof String && ((String)value).startsWith("[") && ((String)value).endsWith("]")) {
            try {
                value = this.objectMapper.readValue((String)value, List.class);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        if (value instanceof String) {
            String[] elements;
            String string = (String)value;
            for (String element : elements = string.split(",")) {
                resultList.add(this.deserialize((Object)element, domainElement));
            }
        } else if (value instanceof Collection) {
            for (Object element : (Collection)value) {
                resultList.add(this.deserialize(element, domainElement));
            }
        } else {
            throw new IllegalStateException("Value " + value + " is not a collection");
        }
        return resultList;
    }

    private boolean isInterval(String domain) {
        return domain.contains("interval");
    }

    private boolean isArray(String domain) {
        return domain.contains("[]");
    }

    private String findDomain(Object value) {
        if (value instanceof Collection) {
            if (((Collection)value).isEmpty()) {
                return "integer[]";
            }
            Object firstElement = ((Collection)value).iterator().next();
            String elementsDomain = this.findDomain(firstElement);
            if (elementsDomain == null) {
                return null;
            }
            return elementsDomain + "[]";
        }
        if (value instanceof String) {
            String val = ((String)value).toLowerCase();
            if (val.equals("true") || value.equals("false")) {
                return Domain.bool.getName();
            }
            if (val.matches("([\\d]{1,6})")) {
                try {
                    Integer.parseInt(val);
                }
                catch (NumberFormatException e) {
                    throw new N2oException("Value is not Integer [" + val + "]. Set domain explicitly!", e);
                }
                return Domain.integer.getName();
            }
            return Domain.string.getName();
        }
        Domain domain = Domain.getByClass(value.getClass());
        return domain != null ? domain.getName() : null;
    }

    private Object toObject(String domain, String value) throws ParseException, IOException, NumberFormatException {
        if (value == null || value.isEmpty()) {
            return null;
        }
        if (Domain.bool.getName().equals(domain)) {
            return Boolean.parseBoolean(value);
        }
        if (Domain.date.getName().equals(domain)) {
            return new SimpleDateFormat(this.dateFormat).parse(value);
        }
        if (Domain.localdate.getName().equals(domain)) {
            return LocalDate.parse(value, DateTimeFormatter.ofPattern(this.dateFormat));
        }
        if (Domain.localdatetime.getName().equals(domain)) {
            return LocalDateTime.parse(value, DateTimeFormatter.ofPattern(this.dateFormat));
        }
        if (Domain.byte_.getName().equals(domain)) {
            return Byte.parseByte(value);
        }
        if (Domain.short_.getName().equals(domain)) {
            return Short.parseShort(value);
        }
        if (Domain.integer.getName().equals(domain)) {
            return Integer.parseInt(value);
        }
        if (Domain.long_.getName().equals(domain)) {
            return Long.parseLong(value);
        }
        if (Domain.object.getName().equals(domain)) {
            return this.objectMapper.readValue(value, DataSet.class);
        }
        if (Domain.numeric.getName().equals(domain)) {
            return new BigDecimal(value.replace(",", "."));
        }
        return value;
    }

    public static String getDomain(String simpleDomain, FilterType type) {
        switch (type.arity) {
            case unary: {
                return simpleDomain;
            }
            case n_ary: {
                return simpleDomain != null ? simpleDomain + "[]" : null;
            }
            case nullary: {
                return "boolean";
            }
        }
        throw new RuntimeException(String.format("arity '%s' for filter-type '%s' is unknown", type.arity, type));
    }

    static {
        simpleDomainsMap.put(Integer.class, "integer");
        simpleDomainsMap.put(String.class, "string");
        simpleDomainsMap.put(Boolean.class, "boolean");
        simpleDomainsMap.put(Date.class, "date");
        simpleDomainsMap.put(LocalDate.class, "localdate");
        simpleDomainsMap.put(LocalDateTime.class, "localdatetime");
        simpleDomainsMap.put(DataSet.class, "object");
        simpleDomainsMap.put(BigDecimal.class, "numeric");
        simpleDomainsMap.put(Long.class, "long");
        simpleDomainsMap.put(Byte.class, "byte");
        simpleDomainsMap.put(Short.class, "short");
    }
}

