/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.data.validation;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.data.InvocationProcessor;
import net.n2oapp.framework.api.data.validation.Validation;
import net.n2oapp.framework.api.data.validation.ValidationFailureCallback;
import net.n2oapp.framework.api.metadata.control.ValidationReference;
import net.n2oapp.framework.api.metadata.meta.control.Field;

public class MandatoryValidation
extends Validation {
    protected Field field;
    private String mandatoryExpression;
    @JsonProperty(value="expression")
    private String enablingExpression;
    private String expressionOn;

    public MandatoryValidation(String id, String message, String fieldId) {
        this.setId(id);
        this.setMessage(message);
        this.setFieldId(fieldId);
        this.setTarget(ValidationReference.Target.field);
    }

    public MandatoryValidation(MandatoryValidation v) {
        super(v);
        this.mandatoryExpression = v.getMandatoryExpression();
        this.expressionOn = v.getExpressionOn();
    }

    @Override
    public void validate(DataSet dataSet, InvocationProcessor serviceProvider, ValidationFailureCallback callback) {
        boolean success;
        boolean bl = success = dataSet.get((Object)this.getFieldId()) != null;
        if (dataSet.get((Object)this.getFieldId()) instanceof String) {
            success = success && !((String)dataSet.get((Object)this.getFieldId())).isEmpty();
        } else if (dataSet.get((Object)this.getFieldId()) instanceof List) {
            success = success && !((List)dataSet.get((Object)this.getFieldId())).isEmpty();
        } else if (dataSet.get((Object)this.getFieldId()) instanceof Map) {
            boolean bl2 = success = success && !((Map)dataSet.get((Object)this.getFieldId())).isEmpty();
        }
        if (!success) {
            callback.onFail(this.getMessage());
        }
    }

    @Override
    public String getType() {
        return "required";
    }

    public Field getField() {
        return this.field;
    }

    public String getMandatoryExpression() {
        return this.mandatoryExpression;
    }

    public String getEnablingExpression() {
        return this.enablingExpression;
    }

    public String getExpressionOn() {
        return this.expressionOn;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public void setMandatoryExpression(String mandatoryExpression) {
        this.mandatoryExpression = mandatoryExpression;
    }

    public void setEnablingExpression(String enablingExpression) {
        this.enablingExpression = enablingExpression;
    }

    public void setExpressionOn(String expressionOn) {
        this.expressionOn = expressionOn;
    }

    public MandatoryValidation() {
    }
}

