/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.event;

import net.n2oapp.framework.api.event.MetadataChangedEvent;
import net.n2oapp.framework.api.event.N2oEventListener;
import net.n2oapp.framework.api.metadata.SourceMetadata;

public abstract class MetadataChangeListener
implements N2oEventListener<MetadataChangedEvent> {
    private boolean any = false;
    private Class<? extends SourceMetadata> sourceClass;
    private String metadataId;

    public MetadataChangeListener(String metadataId, Class<? extends SourceMetadata> sourceClass) {
        this.metadataId = metadataId;
        this.sourceClass = sourceClass;
    }

    public MetadataChangeListener() {
        this.any = true;
    }

    @Override
    public boolean isApply(MetadataChangedEvent event) {
        return this.any || event.isAll() || this.sourceClass.isAssignableFrom(event.getBaseSourceClass()) && this.metadataId.equals(event.getSourceId());
    }

    @Override
    public void handleEvent(MetadataChangedEvent event) {
        if (event.isAll()) {
            this.handleAllMetadataChange();
        } else {
            this.handleMetadataChange(event.getSourceId(), event.getBaseSourceClass());
        }
    }

    public abstract void handleAllMetadataChange();

    public abstract void handleMetadataChange(String var1, Class<? extends SourceMetadata> var2);
}

