/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.metadata.control;

import java.io.Serializable;
import java.util.Arrays;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.IdAware;
import net.n2oapp.framework.api.metadata.control.N2oComponent;
import net.n2oapp.framework.api.metadata.global.dao.validation.N2oValidation;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oToolbar;

public abstract class N2oField
extends N2oComponent
implements IdAware {
    private String id;
    private Boolean visible;
    private Boolean required;
    private Boolean enabled;
    private String[] dependsOn;
    @Deprecated
    private String style;
    private String label;
    private String labelClass;
    @Deprecated
    private String labelStyle;
    private String description;
    private String help;
    private String domain;
    private Boolean noLabel;
    private N2oToolbar toolbar;
    private Dependency[] dependencies;

    public void addDependency(Dependency d) {
        if (d == null) {
            return;
        }
        if (this.dependencies == null) {
            this.dependencies = new Dependency[1];
            this.dependencies[0] = d;
        } else {
            this.dependencies = Arrays.copyOf(this.dependencies, this.dependencies.length + 1);
            this.dependencies[this.dependencies.length - 1] = d;
        }
    }

    public boolean containsDependency(Class<? extends Dependency> clazz) {
        if (this.dependencies == null) {
            return false;
        }
        for (Dependency dependency : this.dependencies) {
            if (!dependency.getClass().equals(clazz)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getId() + ")";
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Boolean getVisible() {
        return this.visible;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public String[] getDependsOn() {
        return this.dependsOn;
    }

    @Deprecated
    public String getStyle() {
        return this.style;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLabelClass() {
        return this.labelClass;
    }

    @Deprecated
    public String getLabelStyle() {
        return this.labelStyle;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHelp() {
        return this.help;
    }

    public String getDomain() {
        return this.domain;
    }

    public Boolean getNoLabel() {
        return this.noLabel;
    }

    public N2oToolbar getToolbar() {
        return this.toolbar;
    }

    public Dependency[] getDependencies() {
        return this.dependencies;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setDependsOn(String[] dependsOn) {
        this.dependsOn = dependsOn;
    }

    @Deprecated
    public void setStyle(String style) {
        this.style = style;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setLabelClass(String labelClass) {
        this.labelClass = labelClass;
    }

    @Deprecated
    public void setLabelStyle(String labelStyle) {
        this.labelStyle = labelStyle;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setNoLabel(Boolean noLabel) {
        this.noLabel = noLabel;
    }

    public void setToolbar(N2oToolbar toolbar) {
        this.toolbar = toolbar;
    }

    public void setDependencies(Dependency[] dependencies) {
        this.dependencies = dependencies;
    }

    public static class VisibilityDependency
    extends Dependency {
        private Boolean reset;

        public Boolean getReset() {
            return this.reset;
        }

        public void setReset(Boolean reset) {
            this.reset = reset;
        }
    }

    public static class FetchDependency
    extends Dependency {
    }

    public static class SetValueDependency
    extends Dependency {
    }

    public static class RequiringDependency
    extends Dependency {
    }

    public static class EnablingDependency
    extends Dependency {
    }

    public static class Dependency
    implements Source {
        private String[] on;
        private String value;
        private Boolean applyOnInit;

        public String[] getOn() {
            return this.on;
        }

        public String getValue() {
            return this.value;
        }

        public Boolean getApplyOnInit() {
            return this.applyOnInit;
        }

        public void setOn(String[] on) {
            this.on = on;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setApplyOnInit(Boolean applyOnInit) {
            this.applyOnInit = applyOnInit;
        }
    }

    public static class Validations
    implements Serializable {
        private N2oValidation[] inlineValidations;
        private String[] whiteList;

        public N2oValidation[] getInlineValidations() {
            return this.inlineValidations;
        }

        public String[] getWhiteList() {
            return this.whiteList;
        }

        public void setInlineValidations(N2oValidation[] inlineValidations) {
            this.inlineValidations = inlineValidations;
        }

        public void setWhiteList(String[] whiteList) {
            this.whiteList = whiteList;
        }
    }
}

