/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.metadata.control.properties;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.n2oapp.framework.api.metadata.control.N2oFieldCondition;
import net.n2oapp.framework.api.script.ScriptProcessor;

public class RequiredCondition
extends N2oFieldCondition {
    private Map<String, String> vars = new HashMap<String, String>();
    private String clientCondition;

    public String getClientCondition() {
        return this.clientCondition;
    }

    public Map<String, String> getVars() {
        return this.vars;
    }

    public void prepareForClient(ScriptProcessor scriptProcessor) {
        String condition = this.getCondition();
        Set<String> on = this.getOn() != null ? Arrays.stream(this.getOn().split(Pattern.quote(","))).map(String::trim).collect(Collectors.toSet()) : ScriptProcessor.extractVars(condition);
        for (String var : on) {
            String jsVar = this.replaceBraces(var);
            jsVar = jsVar.replace(".", "");
            condition = condition.replaceAll(var, "\\$" + jsVar);
            this.vars.put("$" + jsVar, var);
        }
        Pattern pattern = Pattern.compile("\\${2,}");
        Matcher matcher = pattern.matcher(condition);
        if (matcher.find()) {
            condition = matcher.replaceAll("\\$");
        }
        this.clientCondition = condition;
    }

    public String getVarsEnumeration() {
        StringBuilder sb = new StringBuilder();
        boolean begin = true;
        for (String var : this.vars.keySet()) {
            if (!begin) {
                sb.append(',');
            }
            sb.append(var);
            begin = false;
        }
        return sb.toString();
    }

    private String replaceBraces(String var) {
        return var.replaceAll("\\[", "_").replaceAll("\\]", "_");
    }
}

