/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.metadata.global.dao;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.n2oapp.criteria.filters.FilterType;
import net.n2oapp.framework.api.N2oNamespace;
import net.n2oapp.framework.api.metadata.Compiled;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.ExtensionAttributesAware;
import net.n2oapp.framework.api.metadata.global.N2oMetadata;
import net.n2oapp.framework.api.metadata.global.aware.IdAware;
import net.n2oapp.framework.api.metadata.global.aware.NameAware;
import net.n2oapp.framework.api.metadata.global.dao.invocation.model.N2oInvocation;

public class N2oQuery
extends N2oMetadata
implements NameAware,
ExtensionAttributesAware {
    protected Field[] fields;
    private String name;
    private String objectId;
    private String route;
    private Selection[] lists;
    private Selection[] uniques;
    private Selection[] counts;
    private Map<N2oNamespace, Map<String, String>> extAttributes;

    @Override
    public final String getPostfix() {
        return "query";
    }

    public final Class<? extends N2oMetadata> getSourceBaseClass() {
        return N2oQuery.class;
    }

    public Field[] getFields() {
        return this.fields;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public String getRoute() {
        return this.route;
    }

    public Selection[] getLists() {
        return this.lists;
    }

    public Selection[] getUniques() {
        return this.uniques;
    }

    public Selection[] getCounts() {
        return this.counts;
    }

    @Override
    public Map<N2oNamespace, Map<String, String>> getExtAttributes() {
        return this.extAttributes;
    }

    public void setFields(Field[] fields) {
        this.fields = fields;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public void setRoute(String route) {
        this.route = route;
    }

    public void setLists(Selection[] lists) {
        this.lists = lists;
    }

    public void setUniques(Selection[] uniques) {
        this.uniques = uniques;
    }

    public void setCounts(Selection[] counts) {
        this.counts = counts;
    }

    @Override
    public void setExtAttributes(Map<N2oNamespace, Map<String, String>> extAttributes) {
        this.extAttributes = extAttributes;
    }

    public static class Selection
    implements Source,
    Compiled {
        private String filters;
        private String resultMapping;
        private String countMapping;
        private N2oInvocation invocation;
        private Type type;

        public Selection(Type type) {
            this.type = type;
        }

        public Selection(Type type, N2oInvocation invocation) {
            this(type);
            this.invocation = invocation;
        }

        public String getFilters() {
            return this.filters;
        }

        public String getResultMapping() {
            return this.resultMapping;
        }

        public String getCountMapping() {
            return this.countMapping;
        }

        public N2oInvocation getInvocation() {
            return this.invocation;
        }

        public Type getType() {
            return this.type;
        }

        public void setFilters(String filters) {
            this.filters = filters;
        }

        public void setResultMapping(String resultMapping) {
            this.resultMapping = resultMapping;
        }

        public void setCountMapping(String countMapping) {
            this.countMapping = countMapping;
        }

        public void setInvocation(N2oInvocation invocation) {
            this.invocation = invocation;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public static enum Type {
            list,
            unique,
            count;

        }
    }

    public static class Field
    implements Source,
    Compiled,
    NameAware,
    IdAware {
        public static final String PK = "id";
        public static List<String> INTERVAL_ATTRIBUTE = Arrays.asList("begin", "end");
        public static final String MULTI_ATTRIBUTE = "*";
        private String id;
        private String name;
        private String domain;
        private String expression;
        private String sortingBody;
        private String sortingMapping;
        private String selectBody;
        private String selectDefaultValue;
        private String selectMapping;
        private String normalize;
        private Filter[] filterList;
        private String joinBody;
        private Boolean noSorting;
        private Boolean noDisplay;
        private Boolean noJoin;

        public static String getReference(String fieldId) {
            if (fieldId == null) {
                return null;
            }
            int idx = fieldId.lastIndexOf(".");
            if (idx < 0) {
                return fieldId;
            }
            if (Field.isMulti(fieldId)) {
                idx = fieldId.lastIndexOf(MULTI_ATTRIBUTE);
            }
            return fieldId.substring(0, idx);
        }

        public Field(String id) {
            this.setId(id);
        }

        public Field() {
        }

        public boolean isFK() {
            ArrayList<String> suffix = new ArrayList<String>(INTERVAL_ATTRIBUTE);
            suffix.add(PK);
            return suffix.stream().anyMatch(s -> this.getId().endsWith("." + s));
        }

        public boolean isPK() {
            return this.getId().equalsIgnoreCase(PK);
        }

        public boolean isSelf() {
            return !this.isHasPoint() || this.isFK() && this.isPlaneReference();
        }

        private boolean isPlaneReference() {
            return !this.getOwnReference().contains(".");
        }

        public boolean isHasPoint() {
            return this.getId().contains(".");
        }

        public String getOwnReference() {
            return Field.getReference(this.getId());
        }

        public Type getType() {
            if (!this.isHasPoint()) {
                return Type.simple;
            }
            if (this.isPlaneReference() && INTERVAL_ATTRIBUTE.stream().anyMatch(a -> this.getId().endsWith("." + a))) {
                return Type.interval;
            }
            if (this.isFK() && !this.isMulti()) {
                return Type.list;
            }
            if (this.isMulti()) {
                return Type.multi;
            }
            return null;
        }

        public boolean isMulti() {
            return Field.isMulti(this.getId());
        }

        public static boolean isMulti(String fieldId) {
            return fieldId != null && fieldId.contains("*.");
        }

        public Boolean getHasSorting() {
            return this.noSorting == false;
        }

        public void setHasSorting(Boolean hasSorting) {
            this.noSorting = hasSorting == false;
        }

        public Boolean getHasSelect() {
            return this.noDisplay == false;
        }

        public void setHasSelect(Boolean hasDisplay) {
            this.noDisplay = hasDisplay == false;
        }

        public Boolean getHasJoin() {
            return this.noJoin == false;
        }

        public void setHasJoin(Boolean hasJoin) {
            this.noJoin = hasJoin == false;
        }

        public boolean isSearchUnavailable() {
            return this.getFilterList() == null;
        }

        public String toString() {
            return this.id;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getDomain() {
            return this.domain;
        }

        public String getExpression() {
            return this.expression;
        }

        public String getSortingBody() {
            return this.sortingBody;
        }

        public String getSortingMapping() {
            return this.sortingMapping;
        }

        public String getSelectBody() {
            return this.selectBody;
        }

        public String getSelectDefaultValue() {
            return this.selectDefaultValue;
        }

        public String getSelectMapping() {
            return this.selectMapping;
        }

        public String getNormalize() {
            return this.normalize;
        }

        public Filter[] getFilterList() {
            return this.filterList;
        }

        public String getJoinBody() {
            return this.joinBody;
        }

        public Boolean getNoSorting() {
            return this.noSorting;
        }

        public Boolean getNoDisplay() {
            return this.noDisplay;
        }

        public Boolean getNoJoin() {
            return this.noJoin;
        }

        @Override
        public void setId(String id) {
            this.id = id;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }

        public void setSortingBody(String sortingBody) {
            this.sortingBody = sortingBody;
        }

        public void setSortingMapping(String sortingMapping) {
            this.sortingMapping = sortingMapping;
        }

        public void setSelectBody(String selectBody) {
            this.selectBody = selectBody;
        }

        public void setSelectDefaultValue(String selectDefaultValue) {
            this.selectDefaultValue = selectDefaultValue;
        }

        public void setSelectMapping(String selectMapping) {
            this.selectMapping = selectMapping;
        }

        public void setNormalize(String normalize) {
            this.normalize = normalize;
        }

        public void setFilterList(Filter[] filterList) {
            this.filterList = filterList;
        }

        public void setJoinBody(String joinBody) {
            this.joinBody = joinBody;
        }

        public void setNoSorting(Boolean noSorting) {
            this.noSorting = noSorting;
        }

        public void setNoDisplay(Boolean noDisplay) {
            this.noDisplay = noDisplay;
        }

        public void setNoJoin(Boolean noJoin) {
            this.noJoin = noJoin;
        }

        public static enum Type {
            simple,
            list,
            interval,
            multi;

        }
    }

    public static class Filter
    implements Source,
    Compiled {
        private String text;
        private String defaultValue;
        private Object compiledDefaultValue;
        private FilterType type;
        private String filterField;
        private String domain;
        private String normalize;
        private String mapping;
        private Boolean required;
        private String param;
        private boolean generated = false;

        public Filter(String filterField, FilterType type) {
            this.filterField = filterField;
            this.type = type;
        }

        public Filter(String filterField, FilterType type, String filterBody) {
            this.text = filterBody;
            this.filterField = filterField;
            this.type = type;
        }

        public Filter(String filterField, FilterType type, String filterBody, String domain) {
            this.filterField = filterField;
            this.type = type;
            this.text = filterBody;
            this.domain = domain;
        }

        public Filter(String filterField, FilterType type, String filterBody, String domain, String normalize) {
            this.type = type;
            this.filterField = filterField;
            this.domain = domain;
            this.normalize = normalize;
            this.text = filterBody;
        }

        public Filter() {
        }

        public String getText() {
            return this.text;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public Object getCompiledDefaultValue() {
            return this.compiledDefaultValue;
        }

        public FilterType getType() {
            return this.type;
        }

        public String getFilterField() {
            return this.filterField;
        }

        public String getDomain() {
            return this.domain;
        }

        public String getNormalize() {
            return this.normalize;
        }

        public String getMapping() {
            return this.mapping;
        }

        public Boolean getRequired() {
            return this.required;
        }

        public String getParam() {
            return this.param;
        }

        public boolean isGenerated() {
            return this.generated;
        }

        public void setText(String text) {
            this.text = text;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setCompiledDefaultValue(Object compiledDefaultValue) {
            this.compiledDefaultValue = compiledDefaultValue;
        }

        public void setType(FilterType type) {
            this.type = type;
        }

        public void setFilterField(String filterField) {
            this.filterField = filterField;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public void setNormalize(String normalize) {
            this.normalize = normalize;
        }

        public void setMapping(String mapping) {
            this.mapping = mapping;
        }

        public void setRequired(Boolean required) {
            this.required = required;
        }

        public void setParam(String param) {
            this.param = param;
        }

        public void setGenerated(boolean generated) {
            this.generated = generated;
        }
    }
}

