/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.metadata.meta;

import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.local.view.widget.util.SubModelQuery;
import net.n2oapp.framework.api.metadata.meta.BindLink;

public class ModelLink
extends BindLink {
    private ReduxModel model;
    private String widgetId;
    private String fieldId;
    private SubModelQuery subModelQuery;
    private String param;

    public ModelLink(Object value) {
        this.setValue(value);
    }

    public ModelLink(ReduxModel model, String widgetId) {
        super(ModelLink.createBindLink(model, widgetId, null));
        this.model = model;
        this.widgetId = widgetId;
    }

    public ModelLink(ReduxModel model, String widgetId, String fieldId) {
        super(ModelLink.createBindLink(model, widgetId, fieldId));
        this.model = model;
        this.widgetId = widgetId;
        this.fieldId = fieldId;
    }

    public String getFieldId() {
        if (this.fieldId != null) {
            return this.fieldId;
        }
        if (this.getFieldValue() != null && this.getFieldValue().contains(".map(function(t){return t.")) {
            return this.getFieldValue().substring(0, this.getFieldValue().indexOf("."));
        }
        return this.fieldId != null ? this.fieldId : this.getFieldValue();
    }

    public ModelLink getWidgetLink() {
        if (this.getModel() == null || this.getWidgetId() == null) {
            return null;
        }
        ModelLink widgetLink = new ModelLink(this.getModel(), this.getWidgetId());
        if (this.getFieldId() == null || this.getFieldId().equals("id")) {
            widgetLink.setSubModelQuery(this.getSubModelQuery());
        }
        return widgetLink;
    }

    @Override
    public boolean equalsLink(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ModelLink that = (ModelLink)o;
        if (this.model == null || this.widgetId == null || that.model == null || that.widgetId == null) {
            return false;
        }
        String thisFieldId = this.getFieldId();
        if (this.getSubModelQuery() != null) {
            thisFieldId = this.getSubModelQuery().getSubModel();
        }
        String thisSubModelQueryLink = ModelLink.createBindLink(this.getModel(), this.getWidgetId(), thisFieldId);
        String thatFieldId = that.getFieldId();
        if (that.getSubModelQuery() != null) {
            thatFieldId = that.getSubModelQuery().getSubModel();
        }
        String thatSubModelQueryLink = ModelLink.createBindLink(that.getModel(), that.getWidgetId(), thatFieldId);
        if (thisSubModelQueryLink.length() > thatSubModelQueryLink.length()) {
            return thisSubModelQueryLink.startsWith(thatSubModelQueryLink + ".");
        }
        if (thisSubModelQueryLink.length() < thatSubModelQueryLink.length()) {
            return thatSubModelQueryLink.startsWith(thisSubModelQueryLink + ".");
        }
        return thisSubModelQueryLink.equals(thatSubModelQueryLink);
    }

    private static String createBindLink(ReduxModel model, String widgetId, String fieldId) {
        return fieldId == null ? String.format("models.%s['%s']", model.getId(), widgetId) : String.format("models.%s['%s'].%s", model.getId(), widgetId, fieldId);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return "ModelLink{" + super.toString() + ", model=" + this.model + ", widgetId='" + this.widgetId + '\'' + ", fieldId='" + this.fieldId + '\'' + '}';
    }

    public ReduxModel getModel() {
        return this.model;
    }

    public String getWidgetId() {
        return this.widgetId;
    }

    public SubModelQuery getSubModelQuery() {
        return this.subModelQuery;
    }

    public String getParam() {
        return this.param;
    }

    public void setSubModelQuery(SubModelQuery subModelQuery) {
        this.subModelQuery = subModelQuery;
    }

    public void setParam(String param) {
        this.param = param;
    }
}

