/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.metadata.meta;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.Compiled;
import net.n2oapp.framework.api.metadata.meta.BindLink;
import net.n2oapp.framework.api.metadata.meta.ReduxAction;

public class PageRoutes
implements Compiled {
    @JsonProperty
    private List<Route> list = new ArrayList<Route>();
    @JsonProperty
    private Map<String, ReduxAction> pathMapping = new LinkedHashMap<String, ReduxAction>();
    @JsonProperty
    private Map<String, Query> queryMapping = new LinkedHashMap<String, Query>();

    public Route findRouteByUrl(String urlPattern) {
        return this.list.stream().filter(r -> r.getPath().equals(urlPattern)).findFirst().orElseThrow(() -> new N2oException("Route by url [" + urlPattern + "] not found"));
    }

    public void addRoute(Route route) {
        if (!this.list.contains(route) || route.isOtherPage.booleanValue()) {
            if (route.getIsOtherPage() != null && route.getIsOtherPage().booleanValue()) {
                this.list.add(0, route);
            } else {
                this.list.add(route);
            }
        }
    }

    public Route addRoute(String path) {
        Route route = new Route();
        route.setPath(path);
        this.addRoute(route);
        return route;
    }

    public void addPathMapping(String pathParam, ReduxAction action) {
        if (this.pathMapping.containsKey(pathParam) && !this.pathMapping.get(pathParam).equals(action)) {
            throw new N2oException("Page already contains path mapping {0}!").addData(pathParam);
        }
        this.pathMapping.put(pathParam, action);
    }

    public void addPathMappings(Map<String, ReduxAction> pathMappings) {
        if (pathMappings != null) {
            pathMappings.forEach((k, v) -> this.addPathMapping((String)k, (ReduxAction)v));
        }
    }

    public void addQueryMapping(String queryParam, ReduxAction onGet, BindLink onSet) {
        Query query = new Query();
        query.setOnGet(onGet);
        query.setOnSet(onSet);
        if (this.queryMapping.containsKey(queryParam) && !this.queryMapping.get(queryParam).equals(query)) {
            throw new N2oException("Page already contains query mapping {0}!").addData(queryParam);
        }
        this.queryMapping.put(queryParam, query);
    }

    public void setList(List<Route> list) {
        this.list = list;
    }

    public void setPathMapping(Map<String, ReduxAction> pathMapping) {
        this.pathMapping = pathMapping;
    }

    public void setQueryMapping(Map<String, Query> queryMapping) {
        this.queryMapping = queryMapping;
    }

    public List<Route> getList() {
        return this.list;
    }

    public Map<String, ReduxAction> getPathMapping() {
        return this.pathMapping;
    }

    public Map<String, Query> getQueryMapping() {
        return this.queryMapping;
    }

    public static class Query
    implements Compiled {
        @JsonProperty(value="get")
        private ReduxAction onGet;
        @JsonProperty(value="set")
        private BindLink onSet;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Query query = (Query)o;
            if (this.onGet != null ? !this.onGet.equals(query.onGet) : query.onGet != null) {
                return false;
            }
            return this.onSet != null ? this.onSet.equals(query.onSet) : query.onSet == null;
        }

        public int hashCode() {
            int result = this.onGet != null ? this.onGet.hashCode() : 0;
            result = 31 * result + (this.onSet != null ? this.onSet.hashCode() : 0);
            return result;
        }

        public void setOnGet(ReduxAction onGet) {
            this.onGet = onGet;
        }

        public void setOnSet(BindLink onSet) {
            this.onSet = onSet;
        }

        public ReduxAction getOnGet() {
            return this.onGet;
        }

        public BindLink getOnSet() {
            return this.onSet;
        }
    }

    public static class Route
    implements Compiled {
        @JsonProperty
        private String path;
        @JsonProperty
        private Boolean exact = true;
        @JsonProperty
        private Boolean isOtherPage = false;
        private boolean resolved;

        public Route(String path) {
            this.path = path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Route route = (Route)o;
            return this.path != null ? this.path.equals(route.path) : route.path == null;
        }

        public int hashCode() {
            return this.path != null ? this.path.hashCode() : 0;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setExact(Boolean exact) {
            this.exact = exact;
        }

        public void setIsOtherPage(Boolean isOtherPage) {
            this.isOtherPage = isOtherPage;
        }

        public void setResolved(boolean resolved) {
            this.resolved = resolved;
        }

        public String getPath() {
            return this.path;
        }

        public Boolean getExact() {
            return this.exact;
        }

        public Boolean getIsOtherPage() {
            return this.isOtherPage;
        }

        public boolean isResolved() {
            return this.resolved;
        }

        public Route() {
        }
    }
}

