/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.metadata.meta.widget;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.n2oapp.framework.api.data.validation.Validation;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.Component;
import net.n2oapp.framework.api.metadata.event.action.UploadType;
import net.n2oapp.framework.api.metadata.meta.Filter;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.action.Action;
import net.n2oapp.framework.api.metadata.meta.toolbar.Toolbar;
import net.n2oapp.framework.api.metadata.meta.widget.WidgetComponent;
import net.n2oapp.framework.api.metadata.meta.widget.WidgetDataProvider;
import net.n2oapp.framework.api.metadata.meta.widget.WidgetDependency;

public abstract class Widget<T extends WidgetComponent>
extends Component {
    private String id;
    private String route;
    private String masterParam;
    private ModelLink masterLink;
    private Boolean opened;
    private String name;
    @JsonProperty
    private String icon;
    private UploadType upload;
    private String objectId;
    private String queryId;
    private List<Filter> filters;
    protected T component;
    private Set<String> notCopiedFields;
    private List<Validation> validations = new ArrayList<Validation>();
    @JsonProperty
    private WidgetDataProvider dataProvider;
    @JsonProperty
    private Toolbar toolbar;
    @JsonProperty
    private Map<String, Action> actions;
    @JsonProperty
    private WidgetDependency dependency;
    @JsonProperty
    private Boolean visible;

    public Widget() {
    }

    public Widget(T component) {
        this.component = component;
    }

    public Filter getFilter(String filterId) {
        if (this.filters == null) {
            return null;
        }
        return this.filters.stream().filter(f -> f.getFilterId().equals(filterId)).findFirst().orElseThrow(() -> new N2oException("Filter " + filterId + " not found"));
    }

    public String getId() {
        return this.id;
    }

    public String getRoute() {
        return this.route;
    }

    public String getMasterParam() {
        return this.masterParam;
    }

    public ModelLink getMasterLink() {
        return this.masterLink;
    }

    public Boolean getOpened() {
        return this.opened;
    }

    public String getName() {
        return this.name;
    }

    public String getIcon() {
        return this.icon;
    }

    public UploadType getUpload() {
        return this.upload;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public T getComponent() {
        return this.component;
    }

    public Set<String> getNotCopiedFields() {
        return this.notCopiedFields;
    }

    public List<Validation> getValidations() {
        return this.validations;
    }

    public WidgetDataProvider getDataProvider() {
        return this.dataProvider;
    }

    public Toolbar getToolbar() {
        return this.toolbar;
    }

    public Map<String, Action> getActions() {
        return this.actions;
    }

    public WidgetDependency getDependency() {
        return this.dependency;
    }

    public Boolean getVisible() {
        return this.visible;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setRoute(String route) {
        this.route = route;
    }

    public void setMasterParam(String masterParam) {
        this.masterParam = masterParam;
    }

    public void setMasterLink(ModelLink masterLink) {
        this.masterLink = masterLink;
    }

    public void setOpened(Boolean opened) {
        this.opened = opened;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setUpload(UploadType upload) {
        this.upload = upload;
    }

    public void setObjectId(String objectId) {
        this.objectId = objectId;
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public void setComponent(T component) {
        this.component = component;
    }

    public void setNotCopiedFields(Set<String> notCopiedFields) {
        this.notCopiedFields = notCopiedFields;
    }

    public void setValidations(List<Validation> validations) {
        this.validations = validations;
    }

    public void setDataProvider(WidgetDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public void setToolbar(Toolbar toolbar) {
        this.toolbar = toolbar;
    }

    public void setActions(Map<String, Action> actions) {
        this.actions = actions;
    }

    public void setDependency(WidgetDependency dependency) {
        this.dependency = dependency;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }
}

