/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.register;

import java.util.Objects;
import net.n2oapp.framework.api.metadata.SourceMetadata;

public class MetaType {
    private String sourceType;
    private Class<? extends SourceMetadata> baseSourceClass;

    public MetaType(String sourceType, Class<? extends SourceMetadata> baseSourceClass) {
        if (sourceType == null) {
            throw new IllegalArgumentException("SourceType must not be null");
        }
        if (baseSourceClass == null) {
            throw new IllegalArgumentException("BaseSourceClass must not be null");
        }
        this.sourceType = sourceType;
        this.baseSourceClass = baseSourceClass;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public Class<? extends SourceMetadata> getBaseSourceClass() {
        return this.baseSourceClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetaType)) {
            return false;
        }
        MetaType metaType = (MetaType)o;
        return Objects.equals(this.sourceType, metaType.sourceType) && Objects.equals(this.baseSourceClass, metaType.baseSourceClass);
    }

    public int hashCode() {
        return Objects.hash(this.sourceType, this.baseSourceClass);
    }

    public String toString() {
        return this.sourceType + ":" + this.baseSourceClass.getSimpleName();
    }
}

