/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.register;

import java.io.Serializable;
import java.util.Objects;
import net.n2oapp.framework.api.metadata.SourceMetadata;
import net.n2oapp.framework.api.reader.SourceLoader;

public abstract class SourceInfo
implements Serializable {
    protected String id;
    protected Class<? extends SourceMetadata> baseSourceClass;

    protected SourceInfo() {
    }

    public SourceInfo(String id, Class<? extends SourceMetadata> baseSourceClass) {
        if (id == null) {
            throw new IllegalArgumentException("Id must not be null");
        }
        if (baseSourceClass == null) {
            throw new IllegalArgumentException("BaseSourceClass must not be null");
        }
        this.id = id;
        this.baseSourceClass = baseSourceClass;
    }

    public abstract Class<? extends SourceLoader> getReaderClass();

    public String getId() {
        return this.id;
    }

    public Class<? extends SourceMetadata> getBaseSourceClass() {
        return this.baseSourceClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SourceInfo)) {
            return false;
        }
        SourceInfo that = (SourceInfo)o;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getBaseSourceClass(), that.getBaseSourceClass());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getBaseSourceClass());
    }

    public String toString() {
        return this.getId() + "." + this.getBaseSourceClass().getSimpleName();
    }
}

