/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.user;

import java.util.HashMap;
import java.util.Map;
import net.n2oapp.framework.api.context.Context;
import net.n2oapp.framework.api.context.ContextEngine;

public class UserContext
implements Context {
    public static final String USERNAME = "username";
    public static final String CONTEXT = "contextId";
    public static final String SESSION = "sessionId";
    private ContextEngine ctx;
    private Map<String, Object> requestCache = new HashMap<String, Object>();

    public UserContext(ContextEngine context) {
        this.ctx = context;
    }

    public UserContext(ContextEngine context, Map<String, Object> requestCache) {
        this.ctx = context;
        this.requestCache = requestCache;
    }

    public String getUsername() {
        Object result = this.get(USERNAME);
        return result != null ? result.toString() : "";
    }

    public String getContextId() {
        Object result = this.get(CONTEXT);
        return result != null ? result.toString() : "";
    }

    public String getSessionId() {
        Object result = this.get(SESSION);
        return result != null ? result.toString() : "";
    }

    @Override
    public Object get(String name) {
        if (this.ctx == null) {
            return null;
        }
        Object result = this.ctx.get(name, this.requestCache);
        this.requestCache.put(name, result);
        return result;
    }

    @Override
    public void set(Map<String, Object> dataSet) {
        if (this.ctx == null) {
            return;
        }
        this.ctx.set(dataSet, this.requestCache);
        this.requestCache.putAll(dataSet);
    }
}

