/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.context;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import net.n2oapp.framework.api.NotFoundPlaceholderException;
import net.n2oapp.framework.api.PlaceHoldersResolver;
import net.n2oapp.framework.api.context.Context;
import net.n2oapp.framework.api.exception.NotFoundContextPlaceholderException;

public class ContextProcessor {
    private final PlaceHoldersResolver contextResolver = new PlaceHoldersResolver("#{", "}", new String[0]);
    private Context context;

    public ContextProcessor(Context context) {
        this.context = context;
    }

    public boolean hasContext(String text) {
        return this.contextResolver.hasPlaceHolders(text);
    }

    public String resolveText(String text) {
        try {
            return this.contextResolver.resolve(text, PlaceHoldersResolver.replaceNullByEmpty(PlaceHoldersResolver.replaceOptional(this.context::get)));
        }
        catch (NotFoundPlaceholderException e) {
            throw new NotFoundContextPlaceholderException(e.getPlaceholder());
        }
    }

    public String resolveJson(String json, ObjectMapper objectMapper) {
        try {
            return this.contextResolver.resolveJson(json, PlaceHoldersResolver.replaceOptional(this.context::get), objectMapper);
        }
        catch (NotFoundPlaceholderException e) {
            throw new NotFoundContextPlaceholderException(e.getPlaceholder());
        }
    }

    public Object resolve(Object param) throws NotFoundContextPlaceholderException {
        try {
            return this.contextResolver.resolveValue(param, PlaceHoldersResolver.replaceOptional(this.context::get));
        }
        catch (NotFoundPlaceholderException e) {
            throw new NotFoundContextPlaceholderException(e.getPlaceholder());
        }
    }

    public void set(Map<String, Object> dataSet) {
        this.context.set(dataSet);
    }

    public void set(String name, Object value) {
        this.context.set(name, value);
    }

    public Object get(String name) {
        return this.context.get(name);
    }
}

