/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.exception;

import java.util.Map;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.exception.SeverityType;

public class N2oException
extends RuntimeException {
    private String userMessage;
    private int httpStatus = 500;
    private SeverityType severity = SeverityType.danger;
    private String field;
    private String view;
    private Map<String, String> choice;
    private Object data;

    public static N2oException wrap(Throwable e) {
        if (e instanceof N2oException) {
            return (N2oException)e;
        }
        return new N2oException(e);
    }

    public N2oException() {
    }

    public N2oException(Throwable cause) {
        super(cause);
    }

    public N2oException(Throwable cause, String alertKey) {
        super(cause);
    }

    public N2oException(String message) {
        super(message);
    }

    public N2oException(String message, Throwable cause) {
        super(message, cause);
    }

    @Override
    public String getLocalizedMessage() {
        return StringUtils.resolveLinks(super.getLocalizedMessage(), this.data);
    }

    public N2oException addData(Object ... data) {
        if (data == null) {
            return this;
        }
        if (data.length == 0) {
            return this;
        }
        this.data = data.length == 1 ? data[0] : data;
        return this;
    }

    public String getUserMessage() {
        return this.userMessage;
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public SeverityType getSeverity() {
        return this.severity;
    }

    public String getField() {
        return this.field;
    }

    public String getView() {
        return this.view;
    }

    public Map<String, String> getChoice() {
        return this.choice;
    }

    public Object getData() {
        return this.data;
    }

    public void setUserMessage(String userMessage) {
        this.userMessage = userMessage;
    }

    public void setHttpStatus(int httpStatus) {
        this.httpStatus = httpStatus;
    }

    public void setSeverity(SeverityType severity) {
        this.severity = severity;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setView(String view) {
        this.view = view;
    }

    public void setChoice(Map<String, String> choice) {
        this.choice = choice;
    }

    public void setData(Object data) {
        this.data = data;
    }
}

