/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.metadata.global.dao;

import java.util.Objects;
import net.n2oapp.criteria.filters.FilterType;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;

public class N2oPreFilter
implements Source {
    private String fieldId;
    private String valueAttr;
    private String valuesAttr;
    private FilterType type;
    private String targetWidgetId;
    private String param;
    private String refPageId;
    private String refWidgetId;
    private ReduxModel refModel;
    private String[] values;
    private Boolean required;
    private ResetMode resetMode;
    private Boolean onChange;

    public N2oPreFilter() {
    }

    public N2oPreFilter(String fieldId, String value, FilterType type) {
        this.fieldId = fieldId;
        this.type = type;
        this.valueAttr = value;
    }

    public N2oPreFilter(String fieldId, String[] values, FilterType type) {
        this.fieldId = fieldId;
        this.type = type;
        this.values = values;
    }

    public String getRef() {
        if (this.getValue() != null && this.getValue().startsWith("{") && this.getValue().endsWith("}")) {
            return this.getValue().substring(1, this.getValue().length() - 1);
        }
        return null;
    }

    public void setRef(String ref) {
        this.valueAttr = Placeholders.ref(ref);
    }

    public boolean isRef() {
        return this.getRef() != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof N2oPreFilter)) {
            return false;
        }
        N2oPreFilter that = (N2oPreFilter)o;
        return Objects.equals(this.fieldId, that.fieldId) && Objects.equals(this.refWidgetId, that.refWidgetId) && this.refModel == that.refModel && this.type == that.type;
    }

    public boolean isBoolean() {
        return FilterType.isNull.equals((Object)this.getType()) || FilterType.isNotNull.equals((Object)this.getType());
    }

    public boolean isArray() {
        if (this.getValues() != null && this.getValues().length != 0) {
            assert (this.getValue() == null);
            assert (this.getRef() == null);
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.fieldId, this.refWidgetId, this.refModel, this.type);
    }

    public String getValue() {
        return this.valueAttr == null ? this.valuesAttr : this.valueAttr;
    }

    public String toString() {
        return "N2oPreFilter{fieldId='" + this.fieldId + '\'' + ", type=" + this.type + '}';
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public String getValueAttr() {
        return this.valueAttr;
    }

    public String getValuesAttr() {
        return this.valuesAttr;
    }

    public FilterType getType() {
        return this.type;
    }

    public String getTargetWidgetId() {
        return this.targetWidgetId;
    }

    public String getParam() {
        return this.param;
    }

    public String getRefPageId() {
        return this.refPageId;
    }

    public String getRefWidgetId() {
        return this.refWidgetId;
    }

    public ReduxModel getRefModel() {
        return this.refModel;
    }

    public String[] getValues() {
        return this.values;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public ResetMode getResetMode() {
        return this.resetMode;
    }

    public Boolean getOnChange() {
        return this.onChange;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public void setValueAttr(String valueAttr) {
        this.valueAttr = valueAttr;
    }

    public void setValuesAttr(String valuesAttr) {
        this.valuesAttr = valuesAttr;
    }

    public void setType(FilterType type) {
        this.type = type;
    }

    public void setTargetWidgetId(String targetWidgetId) {
        this.targetWidgetId = targetWidgetId;
    }

    public void setParam(String param) {
        this.param = param;
    }

    public void setRefPageId(String refPageId) {
        this.refPageId = refPageId;
    }

    public void setRefWidgetId(String refWidgetId) {
        this.refWidgetId = refWidgetId;
    }

    public void setRefModel(ReduxModel refModel) {
        this.refModel = refModel;
    }

    public void setValues(String[] values) {
        this.values = values;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public void setResetMode(ResetMode resetMode) {
        this.resetMode = resetMode;
    }

    public void setOnChange(Boolean onChange) {
        this.onChange = onChange;
    }

    public static enum ResetMode {
        on,
        off;

    }
}

