/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.metadata.global.dao.validation;

import java.io.Serializable;
import net.n2oapp.framework.api.exception.SeverityType;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.NamespaceUriAware;
import net.n2oapp.framework.api.metadata.global.aware.IdAware;

public abstract class N2oValidation
implements IdAware,
Source,
NamespaceUriAware {
    private String id;
    private String fieldId;
    private SeverityType severity;
    private ClientMoment clientMoment;
    private ServerMoment serverMoment;
    private String message;
    private String namespaceUri;
    private String enabled;
    private String side;

    @Override
    public void setNamespaceUri(String namespaceUri) {
        this.namespaceUri = namespaceUri;
    }

    @Override
    public String getNamespaceUri() {
        return "";
    }

    public String getMoment() {
        if (this.serverMoment == null) {
            return null;
        }
        if (this.serverMoment.equals(ServerMoment.beforeOperation)) {
            return "before-action";
        }
        if (this.serverMoment.equals(ServerMoment.afterSuccessOperation)) {
            return "after-success-action";
        }
        if (this.serverMoment.equals(ServerMoment.afterFailOperation)) {
            return "after-fail-action";
        }
        return this.serverMoment.getId();
    }

    public void setMoment(String moment) {
        if (moment == null) {
            this.serverMoment = null;
        } else if ("before-action".equalsIgnoreCase(moment)) {
            this.serverMoment = ServerMoment.beforeOperation;
        } else if ("after-success-action".equalsIgnoreCase(moment)) {
            this.serverMoment = ServerMoment.afterSuccessOperation;
        } else if ("after-fail-action".equalsIgnoreCase(moment)) {
            this.serverMoment = ServerMoment.afterFailOperation;
        } else if ("before-query".equalsIgnoreCase(moment)) {
            this.serverMoment = ServerMoment.beforeQuery;
        } else if ("after-success-query".equalsIgnoreCase(moment)) {
            this.serverMoment = ServerMoment.afterSuccessQuery;
        } else if ("after-fail-query".equalsIgnoreCase(moment)) {
            this.serverMoment = ServerMoment.afterFailQuery;
        }
    }

    public Level getLevel() {
        if (SeverityType.danger.equals(this.severity)) {
            return Level.error;
        }
        return Level.valueOf(this.severity.name());
    }

    public void setLevel(Level level) {
        this.severity = level.getSeverity();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public SeverityType getSeverity() {
        return this.severity;
    }

    public ClientMoment getClientMoment() {
        return this.clientMoment;
    }

    public ServerMoment getServerMoment() {
        return this.serverMoment;
    }

    public String getMessage() {
        return this.message;
    }

    public String getEnabled() {
        return this.enabled;
    }

    public String getSide() {
        return this.side;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public void setSeverity(SeverityType severity) {
        this.severity = severity;
    }

    public void setClientMoment(ClientMoment clientMoment) {
        this.clientMoment = clientMoment;
    }

    public void setServerMoment(ServerMoment serverMoment) {
        this.serverMoment = serverMoment;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setEnabled(String enabled) {
        this.enabled = enabled;
    }

    public void setSide(String side) {
        this.side = side;
    }

    public static enum ClientMoment implements IdAware
    {
        beforeLoad("before-load"),
        afterLoad("after-load"),
        beforeStore("before-store"),
        afterStore("after-store"),
        beforeSubmit("before-submit"),
        afterSubmit("after-submit");

        private String id;

        private ClientMoment(String id) {
            this.id = id;
        }

        @Override
        public String getId() {
            return this.id;
        }
    }

    public static enum ServerMoment implements IdAware
    {
        beforeOperation("before-operation"),
        beforeQuery("before-query"),
        afterSuccessQuery("after-success-query"),
        afterFailQuery("after-fail-query"),
        afterFailOperation("after-fail-operation"),
        afterSuccessOperation("after-success-operation");

        private String id;

        private ServerMoment(String id) {
            this.id = id;
        }

        @Override
        public String getId() {
            return this.id;
        }
    }

    @Deprecated
    public static enum Level implements Serializable
    {
        error(SeverityType.danger),
        warning(SeverityType.warning),
        info(SeverityType.info),
        success(SeverityType.success);

        private SeverityType severity;

        private Level(SeverityType severity) {
            this.severity = severity;
        }

        public SeverityType getSeverity() {
            return this.severity;
        }
    }
}

