/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.metadata.local;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.n2oapp.framework.api.data.validation.ConditionValidation;
import net.n2oapp.framework.api.data.validation.Validation;
import net.n2oapp.framework.api.metadata.Compiled;
import net.n2oapp.framework.api.metadata.CompiledMetadata;
import net.n2oapp.framework.api.metadata.aware.PropertiesAware;
import net.n2oapp.framework.api.metadata.global.aware.OriginAware;
import net.n2oapp.framework.api.metadata.global.dao.object.AbstractParameter;
import net.n2oapp.framework.api.metadata.global.dao.object.N2oObject;
import net.n2oapp.framework.api.metadata.global.dao.object.field.ObjectReferenceField;

public class CompiledObject
implements CompiledMetadata {
    public static final String VALIDATION_RESULT_PARAM = "validation";
    private String id;
    private String name;
    private Map<String, Operation> operations;
    private List<AbstractParameter> objectFields;
    private Map<String, AbstractParameter> objectFieldsMap;
    private Map<String, ObjectReferenceField> objectReferenceFieldsMap;
    private List<Validation> validations;
    private Map<String, Validation> validationsMap;
    private String tableName;
    private String entityClass;
    private String appName;
    private String moduleName;
    private String serviceClass;
    private String serviceName;
    private List<Validation> fieldValidations;

    @Override
    public final Class<? extends CompiledMetadata> getCompiledBaseClass() {
        return CompiledObject.class;
    }

    public Map<String, AbstractParameter> getObjectFieldsMap() {
        return this.objectFieldsMap;
    }

    public List<AbstractParameter> getObjectFields() {
        return this.objectFields;
    }

    public void addValidation(Validation v) {
        if (this.validations == null) {
            this.validations = new ArrayList<Validation>();
        }
        if (this.validationsMap == null) {
            this.validationsMap = new HashMap<String, Validation>();
        }
        this.validationsMap.put(v.getId(), v);
        this.validations.add(v);
    }

    public Map<String, Operation> getOperations() {
        return this.operations;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public Class<N2oObject> getSourceClass() {
        return N2oObject.class;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, ObjectReferenceField> getObjectReferenceFieldsMap() {
        return this.objectReferenceFieldsMap;
    }

    public List<Validation> getValidations() {
        return this.validations;
    }

    public Map<String, Validation> getValidationsMap() {
        return this.validationsMap;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getEntityClass() {
        return this.entityClass;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public List<Validation> getFieldValidations() {
        return this.fieldValidations;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOperations(Map<String, Operation> operations) {
        this.operations = operations;
    }

    public void setObjectFields(List<AbstractParameter> objectFields) {
        this.objectFields = objectFields;
    }

    public void setObjectFieldsMap(Map<String, AbstractParameter> objectFieldsMap) {
        this.objectFieldsMap = objectFieldsMap;
    }

    public void setObjectReferenceFieldsMap(Map<String, ObjectReferenceField> objectReferenceFieldsMap) {
        this.objectReferenceFieldsMap = objectReferenceFieldsMap;
    }

    public void setValidations(List<Validation> validations) {
        this.validations = validations;
    }

    public void setValidationsMap(Map<String, Validation> validationsMap) {
        this.validationsMap = validationsMap;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setEntityClass(String entityClass) {
        this.entityClass = entityClass;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setServiceClass(String serviceClass) {
        this.serviceClass = serviceClass;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setFieldValidations(List<Validation> fieldValidations) {
        this.fieldValidations = fieldValidations;
    }

    public static class Operation
    extends N2oObject.Operation
    implements Compiled,
    OriginAware,
    PropertiesAware {
        private Map<String, Object> properties;
        private Map<String, N2oObject.Parameter> inParametersMap;
        private Map<String, N2oObject.Parameter> outParametersMap;
        private List<Validation> validationList;
        private List<ConditionValidation> conditionList;
        private Map<String, Validation> validationsMap;
        private Map<String, Validation> whiteListValidationsMap;
        private Set<String> inParamsSet = new LinkedHashSet<String>();
        private Set<String> outParamsSet = new LinkedHashSet<String>();
        private Boolean auto;

        public Operation(Map<String, N2oObject.Parameter> inParametersMap, Map<String, N2oObject.Parameter> outParametersMap) {
            this.inParametersMap = inParametersMap;
            this.initInParamsSet(inParametersMap, this.inParamsSet);
            this.outParametersMap = outParametersMap;
            this.initInParamsSet(outParametersMap, this.outParamsSet);
        }

        private void initInParamsSet(Map<String, N2oObject.Parameter> parameterMap, Set<String> parameterSet) {
            if (parameterMap != null) {
                for (String param : parameterMap.keySet()) {
                    String[] split = param.split("\\.");
                    String tmp = "";
                    for (String s : split) {
                        if (tmp.length() != 0) {
                            tmp = tmp + '.';
                        }
                        tmp = tmp + s;
                        parameterSet.add(tmp);
                    }
                }
            }
        }

        public Map<String, Validation> getWhiteListValidationsMap() {
            return this.whiteListValidationsMap != null ? this.whiteListValidationsMap : Collections.emptyMap();
        }

        public void setWhiteListValidationsMap(Map<String, Validation> whiteListValidationsMap) {
            this.whiteListValidationsMap = whiteListValidationsMap;
        }

        public boolean isValidationEnable() {
            return this.getValidationList() != null && !this.getValidationList().isEmpty();
        }

        public Map<String, Validation> getValidationsMap() {
            return this.validationsMap != null ? this.validationsMap : Collections.emptyMap();
        }

        @Override
        public boolean isReal() {
            return this.getObjectId() != null;
        }

        public Boolean getAuto() {
            return this.auto;
        }

        public void setAuto(Boolean auto) {
            this.auto = auto;
        }

        @Override
        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public Map<String, N2oObject.Parameter> getInParametersMap() {
            return this.inParametersMap;
        }

        public Map<String, N2oObject.Parameter> getOutParametersMap() {
            return this.outParametersMap;
        }

        public List<Validation> getValidationList() {
            return this.validationList;
        }

        public List<ConditionValidation> getConditionList() {
            return this.conditionList;
        }

        public Set<String> getInParamsSet() {
            return this.inParamsSet;
        }

        public Set<String> getOutParamsSet() {
            return this.outParamsSet;
        }

        @Override
        public void setProperties(Map<String, Object> properties) {
            this.properties = properties;
        }

        public void setInParametersMap(Map<String, N2oObject.Parameter> inParametersMap) {
            this.inParametersMap = inParametersMap;
        }

        public void setOutParametersMap(Map<String, N2oObject.Parameter> outParametersMap) {
            this.outParametersMap = outParametersMap;
        }

        public void setValidationList(List<Validation> validationList) {
            this.validationList = validationList;
        }

        public void setConditionList(List<ConditionValidation> conditionList) {
            this.conditionList = conditionList;
        }

        public void setValidationsMap(Map<String, Validation> validationsMap) {
            this.validationsMap = validationsMap;
        }

        public void setInParamsSet(Set<String> inParamsSet) {
            this.inParamsSet = inParamsSet;
        }

        public void setOutParamsSet(Set<String> outParamsSet) {
            this.outParamsSet = outParamsSet;
        }
    }
}

