/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.script;

import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.criteria.dataset.Interval;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.global.view.widget.table.N2oSwitch;
import net.n2oapp.framework.api.script.ScriptParserException;
import net.n2oapp.properties.StaticProperties;
import org.apache.commons.io.IOUtils;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.NodeVisitor;
import org.mozilla.javascript.ast.PropertyGet;

public class ScriptProcessor {
    private static final ScriptProcessor instance = new ScriptProcessor();
    private static final List<String> momentFuncs = Arrays.asList("moment", "now", "today", "yesterday", "tomorrow", "beginWeek", "endWeek", "beginMonth", "endMonth", "beginQuarter", "endQuarter", "beginYear", "endYear");
    private static final String spread_operator = "*.";
    private String dateFormat;
    private static final ScriptEngineManager engineMgr = new ScriptEngineManager();
    private static volatile ScriptEngine scriptEngine;

    @Deprecated
    public static ScriptProcessor getInstance() {
        return instance;
    }

    public static String resolveLinks(String text) {
        if (text == null) {
            return null;
        }
        if (StringUtils.hasLink(text)) {
            boolean notEnd;
            int idx;
            String expr = text;
            if (expr.contains("${")) {
                while (expr.contains("${")) {
                    idx = expr.indexOf("}", expr.indexOf("${"));
                    notEnd = idx < expr.length() - 1;
                    expr = expr.replaceFirst("\\$\\{", "\\$<");
                    if (notEnd) {
                        expr = expr.substring(0, idx) + ">>" + expr.substring(idx + 1);
                        continue;
                    }
                    expr = expr.substring(0, idx) + ">>";
                }
            }
            if (expr.contains("#{")) {
                while (expr.contains("#{")) {
                    idx = expr.indexOf("}", expr.indexOf("#{"));
                    notEnd = idx < expr.length() - 1;
                    expr = expr.replaceFirst("#\\{", "#<");
                    if (notEnd) {
                        expr = expr.substring(0, idx) + ">>" + expr.substring(idx + 1);
                        continue;
                    }
                    expr = expr.substring(0, idx) + ">>";
                }
            }
            if (StringUtils.hasLink(expr)) {
                expr = ScriptProcessor.resolveToJsString(expr);
                return ScriptProcessor.toJsExpression(expr.replaceAll("#<", "#{").replaceAll("\\$<", "\\${").replaceAll(">>", "}"));
            }
            return expr.replaceAll("#<", "#{").replaceAll("\\$<", "\\${").replaceAll(">>", "}");
        }
        return text;
    }

    public static String resolveFunction(String text) {
        if (text == null) {
            return null;
        }
        String trimmedText = text.trim();
        if (trimmedText.startsWith("(function")) {
            return text;
        }
        if (trimmedText.startsWith("function")) {
            return String.format("(%s)()", trimmedText);
        }
        if (trimmedText.contains("return")) {
            return String.format("(function(){%s})()", trimmedText);
        }
        return trimmedText;
    }

    public static Object resolveExpression(String text) {
        String expression = ScriptProcessor.resolveLinks(text);
        if (expression == null) {
            return null;
        }
        if (expression.equals("true") || expression.equals("false")) {
            return Boolean.valueOf(expression);
        }
        if (expression.matches("([\\d]+)")) {
            try {
                return Integer.parseInt(expression);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return expression;
    }

    public static Object invertExpression(String text) {
        Object result = ScriptProcessor.resolveExpression(text);
        if (result == null) {
            return null;
        }
        if (result instanceof Boolean) {
            return (Boolean)result == false;
        }
        if (!StringUtils.isJs(result)) {
            return result;
        }
        String expr = (String)result;
        expr = expr.substring(1, expr.length() - 1);
        expr = ScriptProcessor.toJsExpression("!(" + expr + ")");
        return expr;
    }

    public static Object resolveArrayExpression(String ... values) {
        if (values.length == 0) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (String value : values) {
            result.add(ScriptProcessor.resolveExpression(value));
        }
        return result;
    }

    private static String toJsExpression(String expression) {
        return "`" + expression + "`";
    }

    public static Object removeJsBraces(Object expression) {
        if (expression instanceof String) {
            return ((String)expression).replaceAll("`", "");
        }
        return expression;
    }

    private static String resolveToJsString(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        String[] split = text.split("\\{");
        if (split.length <= 1) {
            return text;
        }
        if (!split[0].equals("")) {
            sb.append("'".concat(split[0]).concat("'"));
        }
        for (int i = 1; i < split.length; ++i) {
            int idxSuffix = split[i].indexOf("}");
            if (idxSuffix <= 0) continue;
            String value = split[i].substring(0, idxSuffix);
            if (value.contains(spread_operator)) {
                value = value.substring(0, value.indexOf(spread_operator)) + ".map(function(t){return t." + value.substring(value.indexOf(spread_operator) + 2) + "})";
            }
            sb.append("+").append(value);
            if (idxSuffix >= split[i].length() - 1) continue;
            String afterValue = split[i].substring(idxSuffix + 1);
            sb.append("+'").append(afterValue).append("'");
        }
        String res = sb.toString();
        if (res.startsWith("+")) {
            res = res.replaceFirst("\\+", "");
        }
        if (res.endsWith("+")) {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }

    public static String createFunctionCall(String funcName, Object ... args) {
        StringBuilder res = new StringBuilder();
        res.append(funcName);
        res.append('(');
        boolean begin = true;
        for (Object arg : args) {
            if (!begin) {
                res.append(",");
            }
            String str = arg instanceof String ? "'" + arg.toString() + "'" : arg.toString();
            res.append(str);
            begin = false;
        }
        res.append(')');
        return res.toString();
    }

    public static String createSelfInvokingFunction(String code) {
        return "function(){" + code + "}()";
    }

    public static String buildSwitchExpression(N2oSwitch n2oSwitch) {
        if (n2oSwitch == null || n2oSwitch.getCases() == null && n2oSwitch.getResolvedCases() == null && n2oSwitch.getDefaultCase() == null || n2oSwitch.getValueFieldId() == null || n2oSwitch.getValueFieldId().length() == 0) {
            return null;
        }
        Map<Object, String> cases = ScriptProcessor.resolveSwitchCases(n2oSwitch.getResolvedCases() != null ? n2oSwitch.getResolvedCases() : n2oSwitch.getCases());
        StringBuilder b = new StringBuilder("`");
        for (Object key : cases.keySet()) {
            b.append(n2oSwitch.getValueFieldId() + " == " + key + " ? ");
            b.append(cases.get(key) + " : ");
        }
        if (n2oSwitch.getDefaultCase() != null) {
            b.append("'" + ScriptProcessor.resolveExpression(n2oSwitch.getDefaultCase()) + "'");
        } else {
            b.append("null");
        }
        return b.toString() + "`";
    }

    public String buildIsNullExpression(String variable) {
        StringBuilder res = null;
        StringBuilder tmpVar = null;
        for (String s : variable.split("\\.")) {
            if (tmpVar == null) {
                tmpVar = new StringBuilder();
            } else {
                tmpVar.append(".");
            }
            tmpVar.append(s);
            if (res == null) {
                res = new StringBuilder();
            } else {
                res.append(" || ");
            }
            res.append(this.buildUndefinedExpression(tmpVar.toString()));
        }
        res.append(" || (" + variable + " === null)");
        return res.toString();
    }

    public String buildIsNotNullExpression(String variable) {
        return variable + " != null";
    }

    private String buildUndefinedExpression(String variable) {
        return "(typeof " + variable + " === 'undefined')";
    }

    public String buildEqualExpression(String variable, Object value) {
        return variable + " == " + this.getString(value);
    }

    public String buildLikeExpression(String variable, String value) {
        String res = "%s.indexOf(%s) !== -1";
        return String.format(res, variable, this.getString(value));
    }

    public String buildLikeStartExpression(String variable, String value) {
        String res = "%s.indexOf(%s) === 0";
        return String.format(res, variable, this.getString(value));
    }

    public String buildInListExpression(String variable, List<Object> values) {
        String res = "_.indexOf(_.isArray(%s) ? %s : [%s], %s) >= 0";
        String array = values.stream().map(this::getString).collect(Collectors.toList()).toString();
        return String.format(res, array, array, array, variable);
    }

    public String buildOverlapListExpression(String variable, List<Object> values) {
        String res = "_.intersection(_.isArray(%s) ? %s : [%s], %s).length > 0";
        return String.format(res, variable, variable, variable, values.stream().map(this::getString).collect(Collectors.toList()).toString());
    }

    public String buildContainsListExpression(String variable, List<Object> values) {
        String res = "_.intersection(_.isArray(%s) ? %s : [%s], %s).length === (%s).length";
        String vals = values.stream().map(this::getString).collect(Collectors.toList()).toString();
        return String.format(res, variable, variable, variable, vals, vals);
    }

    public String buildNotInListExpression(String variable, List<Object> values) {
        return "!(" + this.buildInListExpression(variable, values) + ")";
    }

    public String buildLessExpression(String variable, Comparable comparable) {
        if (comparable instanceof Date) {
            return this.buildLessExpressionForDate(variable, (Date)comparable);
        }
        return variable + " < " + comparable;
    }

    public String buildNotEqExpression(String variable, Object value) {
        return variable + " != " + this.getString(value);
    }

    private String buildLessExpressionForDate(String variable, Date date) {
        StringBuilder exp = new StringBuilder();
        String var = "new Date(%s.replace(/(\\d{2})\\.(\\d{2})\\.(\\d{4})/,'$3-$2-$1')).getTime()";
        var = String.format(var, variable);
        exp.append(var);
        exp.append(" < ");
        String s = "new Date('%s').getTime()";
        exp.append(String.format(s, new SimpleDateFormat("MM.dd.yyyy HH:mm:SS").format(date)));
        return exp.toString();
    }

    public String buildMoreExpression(String variable, Comparable comparable) {
        if (comparable instanceof Date) {
            return this.buildMoreExpressionForDate(variable, (Date)comparable);
        }
        return variable + " > " + comparable;
    }

    private String buildMoreExpressionForDate(String variable, Date date) {
        StringBuilder exp = new StringBuilder();
        String var = "new Date(%s.replace(/(\\d{2})\\.(\\d{2})\\.(\\d{4})/,'$3-$2-$1')).getTime()";
        var = String.format(var, variable);
        exp.append(var);
        exp.append(" > ");
        String s = "new Date('%s').getTime()";
        exp.append(String.format(s, new SimpleDateFormat("MM.dd.yyyy HH:mm:SS").format(date)));
        return exp.toString();
    }

    public String buildInIntervalExpression(String variable, Interval interval) {
        if (interval.getDomain().equals(Date.class)) {
            return this.buildInDateIntervalExpression(variable, (Interval<Date>)interval);
        }
        StringBuilder exp = new StringBuilder();
        exp.append(variable);
        exp.append(" > ");
        exp.append(interval.getBegin());
        exp.append(" && ");
        exp.append(variable);
        exp.append(" < ");
        exp.append(interval.getEnd());
        return exp.toString();
    }

    private String buildInDateIntervalExpression(String variable, Interval<Date> interval) {
        StringBuilder exp = new StringBuilder();
        String var = "new Date(%s.replace(/(\\d{2})\\.(\\d{2})\\.(\\d{4})/,'$3-$2-$1')).getTime()";
        var = String.format(var, variable);
        exp.append(var);
        exp.append(" > ");
        String s = "new Date('%s').getTime()";
        exp.append(String.format(s, new SimpleDateFormat("MM.dd.yyyy HH:mm:SS").format((Date)interval.getBegin())));
        exp.append(" && ");
        exp.append(var);
        exp.append(" < ");
        exp.append(String.format(s, new SimpleDateFormat("MM.dd.yyyy HH:mm:SS").format((Date)interval.getEnd())));
        return exp.toString();
    }

    public static String buildAddConjunctionCondition(String condition, String addedCondition) {
        StringBuilder exp = new StringBuilder();
        exp.append('(').append(condition).append(')').append(" && ").append('(').append(addedCondition).append(')');
        return exp.toString();
    }

    public static Set<String> extractVars(String script) {
        HashSet<String> names = new HashSet<String>();
        AstRoot node = null;
        try {
            node = new Parser().parse(script, null, 1);
        }
        catch (EvaluatorException e) {
            throw new ScriptParserException(script, e);
        }
        class Visitor
        implements NodeVisitor {
            final /* synthetic */ Set val$names;

            Visitor(Set set) {
                this.val$names = set;
            }

            public boolean visit(AstNode node) {
                if (node instanceof PropertyGet) {
                    this.val$names.add(node.toSource());
                    return false;
                }
                if (node instanceof Name) {
                    this.val$names.add(node.toSource());
                }
                return true;
            }
        }
        node.visit((NodeVisitor)new Visitor(names));
        return names;
    }

    public static Map<String, Set<String>> extractPropertiesOf(String script, Collection<String> vars) {
        LinkedHashMap<String, Set<String>> result = new LinkedHashMap<String, Set<String>>();
        Set<String> names = ScriptProcessor.extractVars(script);
        for (String name : names) {
            for (String var : vars) {
                String afterGet;
                int endIdx;
                String prefix = var + ".";
                int idx = name.indexOf(prefix);
                if (idx < 0) continue;
                LinkedHashSet<String> properties = (LinkedHashSet<String>)result.get(var);
                if (properties == null) {
                    properties = new LinkedHashSet<String>();
                    result.put(var, properties);
                }
                if ((endIdx = (afterGet = name.substring(idx + prefix.length())).indexOf(".")) >= 0) {
                    properties.add(afterGet.substring(0, endIdx));
                    continue;
                }
                properties.add(afterGet);
            }
        }
        return result;
    }

    public static String addContextFor(String script, final String context, final Predicate<String> predicate) {
        AstRoot node = new Parser().parse(script, null, 1);
        class Visitor
        implements NodeVisitor {
            Visitor() {
            }

            public boolean visit(AstNode node) {
                if (node instanceof PropertyGet) {
                    PropertyGet left = (PropertyGet)node;
                    while (left.getLeft() instanceof PropertyGet) {
                        left = (PropertyGet)left.getLeft();
                    }
                    if (!predicate.test(left.getTarget().getString())) {
                        return false;
                    }
                    left.setLeft((AstNode)new PropertyGet((AstNode)new Name(1, context), (Name)left.getLeft()));
                    return false;
                }
                if (node instanceof Name) {
                    if (predicate.test(node.getString())) {
                        ((Name)node).setIdentifier(context + '.' + ((Name)node).getIdentifier());
                    }
                    return false;
                }
                return true;
            }
        }
        node.visit((NodeVisitor)new Visitor());
        return node.toSource();
    }

    public static String addContextFor(String script, String context, Collection<String> vars) {
        return ScriptProcessor.addContextFor(script, context, vars::contains);
    }

    public static String addContextForAll(String script, String context) {
        return ScriptProcessor.addContextFor(script, context, (String s) -> true);
    }

    public static String simplifyArrayLinks(String src) {
        StringBuilder sb = new StringBuilder();
        HashSet<String> buffer = new HashSet<String>();
        boolean begin = true;
        for (String tmp : src.split("\\,")) {
            String[] s = tmp.split("\\[");
            if (s.length > 1) {
                tmp = s[0];
            } else {
                s = tmp.split("\\*");
                if (s.length > 1) {
                    tmp = s[0];
                }
            }
            if (buffer.contains(tmp)) continue;
            if (!begin) {
                sb.append(',');
            }
            begin = false;
            buffer.add(tmp);
            sb.append(tmp);
        }
        return sb.toString();
    }

    public static <T> T eval(String script, DataSet dataSet) throws ScriptException {
        ScriptEngine scriptEngine = ScriptProcessor.getScriptEngine();
        Bindings bindings = scriptEngine.createBindings();
        for (String key : dataSet.keySet()) {
            Object var = dataSet.get((Object)key);
            if (var instanceof Collection) {
                bindings.put(key, (Object)((Collection)var).toArray());
                continue;
            }
            bindings.put(key, var);
        }
        return (T)scriptEngine.eval(script, bindings);
    }

    public static boolean evalForBoolean(String script, DataSet dataSet) {
        try {
            Boolean eval = (Boolean)ScriptProcessor.eval(script, dataSet);
            if (eval == null) {
                return false;
            }
            return eval;
        }
        catch (ScriptException e) {
            return false;
        }
    }

    public static String ifNotUndefined(String exp, String ... fields) {
        StringBuilder res = new StringBuilder();
        for (String field : ScriptProcessor.retrieve(fields)) {
            res.append("(typeof ");
            res.append(field);
            res.append(" === 'undefined')");
            res.append(" || ");
        }
        res.append('(');
        res.append(exp);
        res.append(')');
        return res.toString();
    }

    public static String and(List<String> operands) {
        return ScriptProcessor.reduce("&&", operands);
    }

    public static String or(List<String> operands) {
        return ScriptProcessor.reduce("||", operands);
    }

    private static String reduce(String operator, List<String> operands) {
        if (operands == null || operands.isEmpty()) {
            return null;
        }
        return (String)operands.stream().reduce((s1, s2) -> "(" + s1 + ") " + operator + " (" + s2 + ")").orElseGet(null);
    }

    private static List<String> retrieve(String[] fields) {
        ArrayList<String> res = new ArrayList<String>();
        for (String field : fields) {
            res.addAll(ScriptProcessor.retrieve(field));
        }
        return res;
    }

    private static List<String> retrieve(String field) {
        ArrayList<String> res = new ArrayList<String>();
        String[] tmp = field.split("\\.");
        for (int i = 0; i < tmp.length; ++i) {
            res.add(ScriptProcessor.toString(Arrays.copyOfRange(tmp, 0, i + 1)));
        }
        return res;
    }

    private static String toString(String[] array) {
        StringBuilder res = new StringBuilder();
        boolean begin = true;
        for (int i = 0; i < array.length; ++i) {
            if (!begin) {
                res.append('.');
            }
            res.append(array[i]);
            begin = false;
        }
        return res.toString();
    }

    public static ScriptEngine getScriptEngine() {
        if (scriptEngine == null) {
            ScriptProcessor.createScriptEngine();
        }
        return scriptEngine;
    }

    private static synchronized void createScriptEngine() {
        if (scriptEngine == null) {
            scriptEngine = engineMgr.getEngineByName("JavaScript");
            URL momentUrl = ScriptProcessor.class.getClassLoader().getResource("META-INF/resources/js/moment.js");
            URL lodashUrl = ScriptProcessor.class.getClassLoader().getResource("META-INF/resources/js/lodash.js");
            URL numeralUrl = ScriptProcessor.class.getClassLoader().getResource("META-INF/resources/js/numeral.js");
            URL n2oUrl = ScriptProcessor.class.getClassLoader().getResource("META-INF/resources/js/n2o.js");
            try {
                scriptEngine.eval(IOUtils.toString((URL)momentUrl, (String)"UTF-8"));
                scriptEngine.eval(IOUtils.toString((URL)lodashUrl, (String)"UTF-8"));
                scriptEngine.eval(IOUtils.toString((URL)numeralUrl, (String)"UTF-8"));
                scriptEngine.eval(IOUtils.toString((URL)n2oUrl, (String)"UTF-8"));
            }
            catch (IOException | ScriptException e) {
                throw new N2oException(e);
            }
        }
    }

    private String getString(Object value) {
        if (value instanceof String) {
            return "'" + value.toString() + "'";
        }
        if (value instanceof Date) {
            return "'" + new SimpleDateFormat(this.getDateFormat()).format((Date)value) + "'";
        }
        return value.toString();
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    protected String getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = StaticProperties.getProperty((String)"n2o.format.date");
        }
        return this.dateFormat;
    }

    private static boolean isNeedMoment(String script) {
        return momentFuncs.stream().anyMatch(f -> script.contains((CharSequence)f));
    }

    private static Map<Object, String> resolveSwitchCases(Map<?, String> cases) {
        HashMap<Object, String> result = new HashMap<Object, String>();
        for (Map.Entry<?, String> entry : cases.entrySet()) {
            String resultValue;
            Object resultKey = entry.getKey();
            if (resultKey instanceof String) {
                resultKey = "'" + resultKey + "'";
            }
            if (StringUtils.hasLink(entry.getValue())) {
                resultValue = ScriptProcessor.resolveLinks(entry.getValue());
                resultValue = resultValue.substring(1, resultValue.length() - 1);
            } else {
                resultValue = "'" + entry.getValue() + "'";
            }
            result.put(resultKey, resultValue);
        }
        return result;
    }
}

