/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.api.ui;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.metadata.global.dao.object.N2oObject;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.meta.saga.RedirectSaga;
import net.n2oapp.framework.api.ui.RequestInfo;

public class ActionRequestInfo<D>
extends RequestInfo {
    private CompiledObject object;
    private CompiledObject.Operation operation;
    private String choice;
    private boolean isBulk;
    private RedirectSaga redirect;
    private boolean messageOnSuccess = true;
    private boolean messageOnFail = true;
    private Map<String, N2oObject.Parameter> inParametersMap = new LinkedHashMap<String, N2oObject.Parameter>();
    private Map<String, N2oObject.Parameter> outParametersMap = new LinkedHashMap<String, N2oObject.Parameter>();
    private D data;

    public void setOperation(CompiledObject.Operation operation) {
        N2oObject.Parameter srcParam;
        this.operation = operation;
        if (operation.getInParametersMap() != null) {
            for (String paramName : operation.getInParametersMap().keySet()) {
                srcParam = operation.getInParametersMap().get(paramName);
                this.inParametersMap.put(paramName, new N2oObject.Parameter(srcParam));
            }
        }
        if (operation.getOutParametersMap() != null) {
            for (String paramName : operation.getOutParametersMap().keySet()) {
                srcParam = operation.getOutParametersMap().get(paramName);
                this.outParametersMap.put(paramName, new N2oObject.Parameter(srcParam));
            }
        }
    }

    public List<ActionRequestInfo<DataSet>> toList() {
        if (!this.isBulk() || this.getData() == null) {
            return Collections.emptyList();
        }
        return ((Collection)this.getData()).stream().map(dataSet -> {
            ActionRequestInfo<DataSet> info = new ActionRequestInfo<DataSet>();
            info.setData((DataSet)dataSet);
            info.setObject(this.getObject());
            info.setOperation(this.getOperation());
            info.setUser(this.getUser());
            info.setBulk(true);
            info.setChoice(this.getChoice());
            return info;
        }).collect(Collectors.toList());
    }

    public CompiledObject getObject() {
        return this.object;
    }

    public CompiledObject.Operation getOperation() {
        return this.operation;
    }

    public String getChoice() {
        return this.choice;
    }

    public boolean isBulk() {
        return this.isBulk;
    }

    public RedirectSaga getRedirect() {
        return this.redirect;
    }

    public boolean isMessageOnSuccess() {
        return this.messageOnSuccess;
    }

    public boolean isMessageOnFail() {
        return this.messageOnFail;
    }

    public Map<String, N2oObject.Parameter> getInParametersMap() {
        return this.inParametersMap;
    }

    public Map<String, N2oObject.Parameter> getOutParametersMap() {
        return this.outParametersMap;
    }

    public D getData() {
        return this.data;
    }

    public void setObject(CompiledObject object) {
        this.object = object;
    }

    public void setChoice(String choice) {
        this.choice = choice;
    }

    public void setBulk(boolean isBulk) {
        this.isBulk = isBulk;
    }

    public void setRedirect(RedirectSaga redirect) {
        this.redirect = redirect;
    }

    public void setMessageOnSuccess(boolean messageOnSuccess) {
        this.messageOnSuccess = messageOnSuccess;
    }

    public void setMessageOnFail(boolean messageOnFail) {
        this.messageOnFail = messageOnFail;
    }

    public void setInParametersMap(Map<String, N2oObject.Parameter> inParametersMap) {
        this.inParametersMap = inParametersMap;
    }

    public void setOutParametersMap(Map<String, N2oObject.Parameter> outParametersMap) {
        this.outParametersMap = outParametersMap;
    }

    public void setData(D data) {
        this.data = data;
    }
}

