/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.boot;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.annotation.PreDestroy;
import net.n2oapp.framework.boot.mongodb.MongoDbDataProviderEngine;
import net.n2oapp.framework.engine.data.rest.json.RestEngineTimeModule;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={MongoClient.class})
public class N2oMongoAutoConfiguration {
    @Value(value="${n2o.engine.mongodb.connection_url:}")
    private String connectionUrl;
    @Value(value="${n2o.engine.mongodb.dateformat.serialize}")
    private String serializingFormat;
    @Value(value="${n2o.engine.mongodb.dateformat.deserialize}")
    private String[] deserializingFormats;
    @Value(value="${n2o.engine.mongodb.dateformat.exclusion-keys}")
    private String[] exclusionKeys;
    @Deprecated
    private MongoClient mongo;

    @Bean
    @ConditionalOnMissingBean
    public MongoDbDataProviderEngine mongoDbDataProviderEngine(ObjectProvider<MongoClientOptions> options) {
        MongoClientOptions mongoClientOptions = (MongoClientOptions)options.getIfAvailable(() -> MongoClientOptions.builder().build());
        MongoDbDataProviderEngine mongoDbDataProviderEngine = new MongoDbDataProviderEngine(mongoClientOptions, this.mongoObjectMapper());
        return mongoDbDataProviderEngine;
    }

    @PreDestroy
    public void close() {
        if (this.mongo != null) {
            this.mongo.close();
        }
    }

    @Deprecated
    @Bean
    @ConditionalOnProperty(value={"n2o.engine.mongodb.connection_url"})
    public MongoClient mongo() {
        this.mongo = new MongoClient(new MongoClientURI(this.connectionUrl));
        return this.mongo;
    }

    private ObjectMapper mongoObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat(this.serializingFormat));
        RestEngineTimeModule module = new RestEngineTimeModule(this.deserializingFormats, this.exclusionKeys);
        objectMapper.registerModules(new Module[]{module});
        return objectMapper;
    }
}

