/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.boot;

import java.util.HashMap;
import java.util.Map;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.register.route.MetadataRouter;
import net.n2oapp.framework.api.rest.ControllerFactory;
import net.n2oapp.framework.api.ui.AlertMessageBuilder;
import net.n2oapp.framework.ui.controller.DataController;
import net.n2oapp.framework.ui.controller.N2oControllerFactory;
import net.n2oapp.framework.ui.controller.action.SetController;
import net.n2oapp.framework.ui.controller.query.GetController;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ServletComponentScan(value={"net.n2oapp.framework"})
@ComponentScan(basePackages={"net.n2oapp.framework.ui"}, lazyInit=true)
public class N2oRestConfiguration {
    @Value(value="${n2o.ui.message.stacktrace:true}")
    private Boolean showStacktrace;

    @Bean
    ControllerFactory controllerFactory(Map<String, SetController> setControllers, Map<String, GetController> getControllers) {
        HashMap<String, Object> controllers = new HashMap<String, Object>();
        controllers.putAll(setControllers);
        controllers.putAll(getControllers);
        return new N2oControllerFactory(controllers);
    }

    @Bean
    public DataController dataController(ControllerFactory controllerFactory, MetadataEnvironment environment, MetadataRouter router) {
        DataController dataController = new DataController(controllerFactory, environment, router);
        dataController.setMessageBuilder(this.messageBuilder(environment));
        return dataController;
    }

    @Bean
    public AlertMessageBuilder messageBuilder(MetadataEnvironment environment) {
        return new AlertMessageBuilder(environment.getMessageSource(), environment.getSystemProperties(), this.showStacktrace);
    }
}

